/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static StringBuffer getRequestURL(HttpServletRequest req) {
        return req.getRequestURL();
    }

    public static Hashtable parsePostData(int len, ServletInputStream in) {
        try {
            byte[] body = new byte[len];
            int startPos = 0;
            int readChars = in.read(body, startPos, len - startPos);
            while (readChars != -1 && len != startPos) {
                readChars = in.read(body, startPos += readChars, len - startPos);
            }
            if (len != startPos) {
                throw new IOException("Stream ended early");
            }
            String post = new String(body, 0, len, "8859_1");
            return HttpUtils.parseQueryString(post);
        }
        catch (IOException err) {
            throw new IllegalArgumentException("Error parsing request body - " + err.getMessage());
        }
    }

    public static Hashtable parseQueryString(String urlEncodedParams) {
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        StringTokenizer st = new StringTokenizer(urlEncodedParams, "&", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int equalPos = token.indexOf(61);
            if (equalPos == -1) continue;
            String name = token.substring(0, equalPos);
            String value = token.substring(equalPos + 1);
            String decodedName = HttpUtils.decodeURLToken(name);
            String decodedValue = HttpUtils.decodeURLToken(value);
            Object already = params.get(decodedName);
            if (already == null) {
                params.put(decodedName, new String[]{decodedValue});
                continue;
            }
            if (!(already instanceof String[])) continue;
            String[] alreadyArray = (String[])already;
            String[] oneMore = new String[alreadyArray.length + 1];
            System.arraycopy(alreadyArray, 0, oneMore, 0, alreadyArray.length);
            oneMore[oneMore.length - 1] = decodedValue;
            params.put(decodedName, oneMore);
        }
        return params;
    }

    private static String decodeURLToken(String in) {
        StringBuffer workspace = new StringBuffer();
        for (int n = 0; n < in.length(); ++n) {
            char thisChar = in.charAt(n);
            if (thisChar == '+') {
                workspace.append(' ');
                continue;
            }
            if (thisChar == '%') {
                int decoded = Integer.parseInt(in.substring(n + 1, n + 3), 16);
                workspace.append((char)decoded);
                n += 2;
                continue;
            }
            workspace.append(thisChar);
        }
        return workspace.toString();
    }
}

