/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.BoatFilterImpl;
import fr.ifremer.suiviobsmer.bean.CompanyBoatInfos;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.BoatInfos;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.ElligibleBoat;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.FeedBack;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.pages.BoatActivityCalendar;
import fr.ifremer.suiviobsmer.ui.pages.Contacts;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/boats.css"})
public class Boats
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private User user;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private PropertyAccess propertyAccess;
    @Property
    private String sampleRowCode;
    @InjectComponent
    private FeedBack filterFeedback;
    @Property
    private UploadedFile boatsCsvFile;
    @InjectComponent
    private Form importBoatsForm;
    @Property
    private UploadedFile activityCalendarsCsvFile;
    private InputStream activityCalendarLogFile;
    protected static String GZIP_MIMETYPE = "application/x-gzip";
    @Persist
    private BoatFilter boatFilter;
    @Persist
    private SampleRow sampleRow;
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Persist
    private GenericSelectModel<FishingZone> fishingZoneSelectModel;
    @Property
    private String fishingZoneId;
    @Persist
    private boolean filtersHidden;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private Map<Integer, Boat> boats;
    @Property
    @Persist
    private Integer boatSelectedImmatriculation;
    @Property
    private Boat boat;
    private boolean even = true;
    @InjectComponent
    private Zone boatsZone;
    @Persist
    private CompanyBoatInfos companyBoatInfos;
    @InjectComponent
    private Zone boatInfosZone;
    @Inject
    private Block displayBoatInfos;
    @Inject
    private Block editBoatInfos;
    @Property
    private ElligibleBoat elligibleBoat;
    @Property
    private String boatInfosSampleRowCode;
    private boolean boatInfosEditable;
    @Inject
    private ServiceUser serviceUser;
    private GenericSelectModel<Company> companySelectModel;
    @Property
    private String companyId;
    @Property
    private Date boardingFromDate;
    @InjectPage
    private Contacts contacts;
    @InjectPage
    private BoatActivityCalendar calendarPage;

    public boolean isOnlyForAdmin() {
        return false;
    }

    void setupRender() throws SuiviObsmerException {
        this.sampleRow = null;
        this.getSampleRow();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        this.fishingZoneSelectModel = null;
        this.getFishingZoneSelectModel();
        this.sampleRowSelectModel = null;
        this.getSampleRowSelectModel();
        this.companyBoatInfos = null;
        this.boatSelectedImmatriculation = null;
        if (this.isSampleRowExists()) {
            this.filtersHidden = false;
            this.boats = null;
            this.filterFeedback.addInfo("Vous \u00eates en cours de s\u00e9lection d'un navire pour la ligne du plan " + this.sampleRow.getCode());
            this.professionId = this.getSampleRow().getProfession().getTopiaId();
            this.fishingZoneId = this.getSampleRow().getFirstFishingZone().getTopiaId();
            this.getBoatFilter().setSampleRowCode(this.getSampleRow().getCode());
        }
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.sampleRowCode = (String)ec.get(String.class, 0);
        }
    }

    String onPassivate() {
        return this.sampleRowCode;
    }

    @Log
    void onSuccessFromImportBoatsForm() {
        try {
            int[] result = this.serviceBoat.importBoatCsv(this.boatsCsvFile.getStream());
            this.boats = null;
            this.layout.getFeedBack().addInfo(result[0] + " navires import\u00e9s dont " + result[1] + " nouveaux");
        }
        catch (SuiviObsmerException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    InputStream getActivityCalendarLogFile() throws FileNotFoundException {
        if (this.activityCalendarLogFile == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getActivityCalendarLogFile]");
            }
            this.activityCalendarLogFile = this.serviceBoat.getActivityCalendarLogFile();
        }
        return this.activityCalendarLogFile;
    }

    public boolean isLogFileExists() {
        try {
            this.getActivityCalendarLogFile();
            return true;
        }
        catch (FileNotFoundException eee) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Aucun fichier de log existant pour les calendriers d'activit\u00e9");
            }
            return false;
        }
    }

    @Log
    void onSuccessFromImportActivityCalendarsForm() throws SuiviObsmerException, IOException {
        InputStream input = this.activityCalendarsCsvFile.getStream();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Content type : " + this.activityCalendarsCsvFile.getContentType());
        }
        if (this.activityCalendarsCsvFile.getContentType().equals(GZIP_MIMETYPE)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Gzip file");
            }
            input = new GZIPInputStream(input);
        }
        this.serviceBoat.importActivityCalendarCsv(input);
        this.companyBoatInfos = null;
    }

    public StreamResponse onActionFromShowActivityCalendarLogFile() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BoatFilter getBoatFilter() throws SuiviObsmerException {
        if (this.boatFilter == null) {
            this.boatFilter = new BoatFilterImpl();
            if (this.log.isDebugEnabled()) {
                this.log.debug("new BoatFilter");
            }
            if (!this.user.getAdmin()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("set company for boatFilter");
                }
                this.boatFilter.setCompany(this.user.getCompany());
            }
        }
        return this.boatFilter;
    }

    public SampleRow getSampleRow() throws SuiviObsmerException {
        if (this.sampleRow == null && !StringUtils.isEmpty((String)this.sampleRowCode)) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRow]");
            }
            this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowCode);
        }
        return this.sampleRow;
    }

    public boolean isSampleRowExists() throws SuiviObsmerException {
        return this.getSampleRow() != null;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws SuiviObsmerException {
        if (this.sampleRowSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRowsForUser]");
            }
            List sampleRows = this.serviceSampling.getSampleRowsForUser(this.user, true);
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "code", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws SuiviObsmerException {
        if (this.professionSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getProfessions]");
            }
            List professions = this.serviceReferential.getProfessions();
            this.professionSelectModel = new GenericSelectModel(professions, Profession.class, "code", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public GenericSelectModel<FishingZone> getFishingZoneSelectModel() throws SuiviObsmerException {
        if (this.fishingZoneSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getFishingZones]");
            }
            List fishingZones = null;
            fishingZones = this.isSampleRowExists() ? this.getSampleRow().getFishingZone() : this.serviceReferential.getFishingZones();
            this.fishingZoneSelectModel = new GenericSelectModel(fishingZones, FishingZone.class, "code", "topiaId", this.propertyAccess);
        }
        return this.fishingZoneSelectModel;
    }

    public boolean isFiltersHidden() {
        return this.filtersHidden;
    }

    public String getHiddenClass() {
        return this.isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        this.filtersHidden = false;
        return this.filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        this.filtersHidden = true;
        return this.filtersZone.getBody();
    }

    void onSelectedFromReset() {
        this.boatFilter = null;
        this.sampleRowCode = null;
    }

    void onSelectedFromSearch() throws SuiviObsmerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("FILTER : fishingZone=" + this.boatFilter.getFishingZone());
            this.log.debug("FILTER : sampleRowCode=" + this.boatFilter.getSampleRowCode());
            this.log.debug("FILTER : profession=" + this.boatFilter.getProfession());
            this.log.debug("FILTER : boatName=" + this.boatFilter.getBoatName());
            this.log.debug("FILTER : boatImmatriculation=" + this.boatFilter.getBoatImmatriculation());
            this.log.debug("FILTER : boatDistrictCode=" + this.boatFilter.getBoatDistrictCode());
            this.log.debug("FILTER : company=" + this.boatFilter.getCompany());
        }
        Profession profession = (Profession)this.getProfessionSelectModel().findObject(this.professionId);
        FishingZone fishingZone = (FishingZone)this.getFishingZoneSelectModel().findObject(this.fishingZoneId);
        this.boatFilter.setProfession(profession);
        this.boatFilter.setFishingZone(fishingZone);
    }

    void onSuccessFromFiltersForm() throws SuiviObsmerException {
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
    }

    public Map<Integer, Boat> getBoats() throws SuiviObsmerException {
        if (this.boats == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getBoatsByFilter]");
            }
            this.boats = this.serviceBoat.getBoatsByFilter(this.boatFilter);
        }
        return this.boats;
    }

    public String getRowClass() {
        String result = "";
        boolean bl = this.even = !this.even;
        result = this.boatSelectedImmatriculation != null && this.boat.getImmatriculation() == this.boatSelectedImmatriculation.intValue() ? "selected" : (!this.boat.getActive() ? "refused" : (this.even ? "even" : "odd"));
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean canCreateNewContactFromList() throws SuiviObsmerException {
        if (!this.user.getAdmin() && this.isSampleRowExists()) {
            if (this.getSampleRow().isFinished()) {
                return false;
            }
            return this.boat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) {
        this.boatSelectedImmatriculation = boatImma;
        this.companyBoatInfos = null;
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(2, -12);
        this.boardingFromDate = calendar.getTime();
        return this.boatsZone.getBody();
    }

    public boolean isActivityCalendarImportRun() {
        return SuiviObsmerContext.isActivityCalendarImportRun();
    }

    public boolean canShowActiveBoatInfos() {
        return this.user.getAdmin() && this.companyId != null || !this.user.getAdmin();
    }

    public Block getActiveBoatInfosBlock() {
        if (this.boatInfosEditable) {
            return this.editBoatInfos;
        }
        return this.displayBoatInfos;
    }

    public Company getCompany() throws SuiviObsmerException {
        if (this.user.getAdmin() && this.companyId != null) {
            return (Company)this.getCompanySelectModel().findObject(this.companyId);
        }
        return this.user.getCompany();
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws SuiviObsmerException {
        if (this.companySelectModel == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List companies = this.serviceUser.getCompanies(true);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws SuiviObsmerException {
        if (this.companyBoatInfos == null && this.boatSelectedImmatriculation != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getElligibleBoats]");
            }
            this.companyBoatInfos = this.serviceBoat.getCompanyBoatInfos(this.boatSelectedImmatriculation.intValue(), this.getCompany());
        }
        return this.companyBoatInfos;
    }

    public String getBoatName() throws SuiviObsmerException {
        Boat boat = null;
        if (this.getBoatInfos() != null) {
            boat = this.getBoatInfos().getBoat();
        }
        boat = (Boat)this.getBoats().get(this.boatSelectedImmatriculation);
        return boat.getName();
    }

    public BoatInfos getBoatInfos() throws SuiviObsmerException {
        return this.getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactClass() throws SuiviObsmerException {
        Contact contact = this.getCompanyBoatInfos().getLastContact();
        return BusinessUtils.getCSSColorClassForContact((Contact)contact, (boolean)this.user.getAdmin());
    }

    public String getElligibleRowInfos() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse((Boolean)this.elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws SuiviObsmerException {
        if (!this.user.getAdmin() && !this.isElligibleBoatCompanyActiveFalse()) {
            SampleRow row = this.elligibleBoat.getSampleRow();
            if (row.isFinished()) {
                return false;
            }
            Boat boat = this.getBoatInfos().getBoat();
            return boat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    public String getElligibleRowClass() {
        boolean condition1 = this.elligibleBoat.getCompanyActive() == null && !this.elligibleBoat.getGlobalActive();
        return condition1 || this.isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    Block onSuccessFromCompanySelectForm() throws SuiviObsmerException {
        this.companyBoatInfos = null;
        this.getCompanyBoatInfos();
        return this.boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() {
        this.boatInfosEditable = true;
        return this.boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws SuiviObsmerException {
        this.companyBoatInfos = null;
        return this.boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws SuiviObsmerException {
        this.boatInfosEditable = true;
        if (!StringUtils.isEmpty((String)this.boatInfosSampleRowCode)) {
            SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.boatInfosSampleRowCode);
            this.companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws SuiviObsmerException {
        if (!this.boatInfosEditable) {
            this.serviceBoat.createUpdateCompanyBoatInfos(this.companyBoatInfos);
        }
        return this.boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws SuiviObsmerException {
        if (this.user.getAdmin()) {
            this.companyId = this.getCompanyBoatInfos().getCompany().getTopiaId();
        }
        return this.boatInfosZone.getBody();
    }

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws SuiviObsmerException {
        this.sampleRow = this.getSampleRow();
        this.boat = (Boat)this.getBoats().get(boatImmatriculation);
        this.contacts.createNewContact(this.boat, this.sampleRow);
        return this.contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws SuiviObsmerException {
        this.boat = this.getBoatInfos().getBoat();
        this.sampleRow = (SampleRow)this.getSampleRowSelectModel().findObject(sampleRowCode);
        this.contacts.createNewContact(this.boat, this.sampleRow);
        return this.contacts;
    }

    public boolean hasActivityCalendar() throws SuiviObsmerException {
        this.boat = this.getBoatInfos().getBoat();
        return this.boat.sizeActivityCalendar() != 0;
    }

    Object onActionFromShowLastActivityCalendar() throws SuiviObsmerException {
        this.boat = this.getBoatInfos().getBoat();
        this.calendarPage.setBoat(this.boat);
        return this.calendarPage;
    }
}

