/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.ActivityCalendar;
import fr.ifremer.suiviobsmer.entity.ActivityMonth;
import fr.ifremer.suiviobsmer.entity.ActivityProfession;
import fr.ifremer.suiviobsmer.entity.ActivityZone;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/boats.css"})
public class BoatActivityCalendar
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceBoat serviceBoat;
    private ActivityCalendar activityCalendar;
    @Property
    private int month;
    @Property
    private int professionIndex;
    @Property
    private int zoneIndex;
    @Persist
    private Boat boat;

    void setupRender() {
    }

    public boolean isOnlyForAdmin() {
        return false;
    }

    public void setBoat(Boat boat) {
        this.boat = boat;
    }

    public Boat getBoat() {
        return this.boat;
    }

    public List<Boat> getBoats() {
        return Collections.singletonList(this.boat);
    }

    public ActivityCalendar getActivityCalendar() throws SuiviObsmerException {
        if (this.activityCalendar == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getLastActivityCalendar]");
            }
            this.activityCalendar = this.serviceBoat.getLastActivityCalendar(this.getBoat());
        }
        return this.activityCalendar;
    }

    public ActivityMonth getActivityMonth() throws SuiviObsmerException {
        return this.getActivityCalendar().getActivityMonth(this.month);
    }

    public String getMonthName() {
        String libelle = DateUtils.getMonthLibelle((int)this.month);
        return StringUtils.capitalize((String)libelle);
    }

    public int getProfessionIndexMax() {
        int result = 0;
        for (ActivityMonth month : this.activityCalendar.getActivityMonth()) {
            int nbProfessions = month.sizeActivityProfession();
            if (nbProfessions <= result) continue;
            result = nbProfessions;
        }
        return result - 1;
    }

    public boolean hasProfessions() {
        return this.getProfessionIndexMax() != -1;
    }

    public ActivityProfession getActivityProfession() throws SuiviObsmerException {
        if (this.getActivityMonth() == null) {
            return null;
        }
        if (this.professionIndex >= this.getActivityMonth().sizeActivityProfession()) {
            return null;
        }
        return (ActivityProfession)this.getActivityMonth().getActivityProfession().get(this.professionIndex);
    }

    public int getZoneIndexMax() throws SuiviObsmerException {
        int result = 0;
        for (ActivityMonth activityMonth : this.activityCalendar.getActivityMonth()) {
            int nbZones;
            this.month = activityMonth.getMonth();
            ActivityProfession profession = this.getActivityProfession();
            if (profession == null || (nbZones = profession.sizeActivityZone()) <= result) continue;
            result = nbZones;
        }
        return result - 1;
    }

    public ActivityZone getActivityZone() throws SuiviObsmerException {
        ActivityProfession profession = this.getActivityProfession();
        if (profession == null) {
            return null;
        }
        if (this.zoneIndex >= profession.sizeActivityZone()) {
            return null;
        }
        return (ActivityZone)profession.getActivityZone().get(this.zoneIndex);
    }
}

