/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.components;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.FeedBack;
import fr.ifremer.suiviobsmer.ui.pages.Index;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

public class Layout {
    @Inject
    private Logger log;
    @Parameter(required=true, defaultPrefix="literal")
    private String pageTitle;
    @Parameter(required=true, defaultPrefix="literal")
    private String contentId;
    @SessionState
    private User currentUser;
    @Property
    private boolean currentUserExists;
    @InjectComponent
    private FeedBack connexionFeedback;
    @InjectComponent
    private FeedBack contentFeedback;
    @InjectContainer
    private SuiviObsmerPage page;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private Request request;
    @Property
    private String login;
    @Property
    private String password;
    @Property
    private String email;

    void setupRender() {
        if (this.currentUserExists && !this.canShowPage()) {
            this.contentFeedback.addError("Vous n'\u00eates pas autoris\u00e9 \u00e0 acc\u00e9der \u00e0 cette page !");
        }
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getVersion() {
        return SuiviObsmerContext.getProperty((String)"suiviobsmer.version");
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    public String getAdminClass() {
        return this.currentUser.getAdmin() ? " admin" : "";
    }

    public String getSamplingSelected() {
        return this.contentId.equals("so-sampling") ? "selected" : "";
    }

    public String getBoatsSelected() {
        return this.contentId.equals("so-boats") ? "selected" : "";
    }

    public String getContactsSelected() {
        return this.contentId.equals("so-contacts") ? "selected" : "";
    }

    public String getSynthesisSelected() {
        return this.contentId.equals("so-synthesis") ? "selected" : "";
    }

    public String getAdminSelected() {
        return this.contentId.equals("so-admin") ? "selected" : "";
    }

    public boolean canShowPage() {
        if (!this.currentUser.getAdmin()) {
            return !this.page.isOnlyForAdmin();
        }
        return true;
    }

    @Log
    Object onSuccessFromConnexionForm() throws SuiviObsmerException {
        try {
            this.currentUser = this.serviceUser.connect(this.login, this.password);
        }
        catch (SuiviObsmerBusinessException eee) {
            this.connexionFeedback.addError(eee.getMessage());
        }
        return null;
    }

    public boolean hasConnexionErrors() {
        return this.connexionFeedback.hasErrors();
    }

    void onSuccessFromForgetPassword() throws SuiviObsmerException {
        try {
            this.serviceUser.forgetPassword(this.email);
            this.connexionFeedback.addInfo("Un email avec votre nouveau mot de passe vous a \u00e9t\u00e9 envoy\u00e9.");
        }
        catch (SuiviObsmerBusinessException eee) {
            this.connexionFeedback.addError(eee.getMessage());
        }
    }

    @Log
    Object onActionFromExit() {
        this.setCurrentUser(null);
        this.request.getSession(false).invalidate();
        return Index.class;
    }
}

