/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationGroupUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;

public class PopulationGroupHandler
extends InputContentHandler<PopulationGroupUI> {
    private static final Log log = LogFactory.getLog(PopulationGroupHandler.class);

    protected PopulationGroupHandler(PopulationGroupUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationGroupUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            GenericComboModel<PopulationGroup> groupModel = new GenericComboModel<PopulationGroup>();
            if (evt.getNewValue() == null) {
                ((PopulationGroupUI)this.inputContentUI).setPopulationGroup(null);
            }
            if (evt.getNewValue() != null) {
                groupModel.setElementList(((PopulationGroupUI)this.inputContentUI).getBean().getPopulationGroup());
            }
            ((PopulationGroupUI)this.inputContentUI).populationGroupPopulationGroupComboBox.setModel(groupModel);
        });
        ((PopulationGroupUI)this.inputContentUI).addPropertyChangeListener("populationGroup", evt -> {
            if (evt.getNewValue() == null) {
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupMeanWeight.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupPrice.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupReproductionRate.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupMaturityOgive.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupAge.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupMinLength.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupMaxLength.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupComment.setText("");
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupNaturalDeathRate.setMatrix(null);
            }
            if (evt.getNewValue() != null) {
                // empty if block
            }
        });
    }

    protected void setNaturalDeathRateMatrix() {
        block2: {
            try {
                Population population = ((PopulationGroupUI)this.inputContentUI).getBean();
                MatrixND naturalDeathRateMatrix = population.getNaturalDeathRateMatrix();
                MatrixND naturalDeathRateMatrix2 = naturalDeathRateMatrix.getSubMatrix(0, new Object[]{((PopulationGroupUI)this.inputContentUI).getPopulationGroup()});
                ((PopulationGroupUI)this.inputContentUI).fieldPopulationGroupNaturalDeathRate.setMatrix(naturalDeathRateMatrix2.copy());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"No zone defined for this population group", (Throwable)e);
            }
        }
    }

    protected void populationGroupChanged() {
        PopulationGroup selectedPopulationGroup = (PopulationGroup)((PopulationGroupUI)this.inputContentUI).populationGroupPopulationGroupComboBox.getSelectedItem();
        ((PopulationGroupUI)this.inputContentUI).setPopulationGroup(selectedPopulationGroup);
        if (selectedPopulationGroup != null) {
            ((PopulationGroupUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(selectedPopulationGroup);
            this.setNaturalDeathRateMatrix();
        }
    }
}

