/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;

public class MetierMonitor {
    private static Log log = LogFactory.getLog(MetierMonitor.class);
    protected Set<Metier> forbiddenMetier = new HashSet<Metier>();
    protected Set<MultiKey<Object>> forbiddenMetierMonth = new HashSet<MultiKey<Object>>();
    protected Map<TimeStep, MatrixND> noActivity = new HashMap<TimeStep, MatrixND>();

    public void clear() {
        this.forbiddenMetier.clear();
    }

    public void addforbiddenMetier(Metier metier) {
        this.forbiddenMetier.add(metier);
    }

    public void addforbiddenMetier(Metier metier, Month month) {
        this.forbiddenMetierMonth.add((MultiKey<Object>)new MultiKey((Object)metier, (Object)month));
    }

    public void removeforbiddenMetier(Metier metier, Month month) {
        this.forbiddenMetierMonth.remove(new MultiKey((Object)metier, (Object)month));
    }

    public void addforbiddenMetier(Collection<Metier> metiers) {
        this.forbiddenMetier.addAll(metiers);
    }

    public Set<Metier> getForbiddenMetier() {
        return this.forbiddenMetier;
    }

    public boolean isForbidden(Metier metier, Month month) {
        boolean result = this.forbiddenMetier.contains(metier);
        if (!result) {
            result = this.forbiddenMetierMonth.contains(new MultiKey((Object)metier, (Object)month));
        }
        return result;
    }

    public MatrixND getNoActivity(TimeStep step) {
        return this.noActivity.get(step);
    }

    public MatrixND getOrCreateNoActivity(TimeStep step, String name, List<Strategy> strategies, List<Metier> metiers) {
        MatrixND result = this.getNoActivity(step);
        if (result == null) {
            if (strategies.size() == 0) {
                strategies = new ArrayList<Strategy>();
                strategies.add(null);
            }
            if (metiers.size() == 0) {
                metiers = new ArrayList<Metier>();
                metiers.add(null);
            }
            result = MatrixFactory.getInstance().create(name, new List[]{strategies, metiers}, new String[]{I18n.n((String)"isisfish.metierMonitor.strategies", (Object[])new Object[0]), I18n.n((String)"isisfish.metierMonitor.metiers", (Object[])new Object[0])});
            this.setNoActivity(step, result);
        }
        return result;
    }

    public void setNoActivity(TimeStep step, MatrixND nonActivity) {
        this.noActivity.put(step, nonActivity);
    }
}

