/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class SensitivitySpawningBiomassRelativeY5
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivitySpawningBiomassRelativeY5.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};
    @Doc(value="Population")
    public Population param_pop;

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        TimeStep lastStep = simulation.getResultStorage().getLastStep();
        TimeStep firstStep = new TimeStep(11);
        double biomass = 0.0;
        double firstbiomass = 0.0;
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            ResultStorage resultStorage = simulation.getResultStorage();
            MatrixND matfirstdate = resultStorage.getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i = matfirstdate.iterator();
            while (i.hasNext()) {
                i.next();
                Object[] sems = i.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)sems[1];
                TimeStep step = (TimeStep)sems[0];
                if (!step.equals((Object)firstStep)) continue;
                firstbiomass += i.getValue() * group.getMaturityOgive();
            }
            MatrixND matlastdate = resultStorage.getMatrix(pop, ResultName.MATRIX_BIOMASS);
            MatrixIterator i2 = matlastdate.iterator();
            while (i2.hasNext()) {
                i2.next();
                Object[] sems = i2.getSemanticsCoordinates();
                PopulationGroup group = (PopulationGroup)sems[1];
                TimeStep step = (TimeStep)sems[0];
                if (!step.equals((Object)lastStep)) continue;
                biomass += i2.getValue() * group.getMaturityOgive();
            }
        }
        out.write(Double.toString(biomass / firstbiomass));
    }

    public String getDescription() {
        return "Biomass of the genitors for the last time step. Biomass is the sum on the groups and zones";
    }

    public String getExportFilename() {
        return "SensitivityGenitorBiomassRelativeY5_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

