/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.ReverseFileReader;
import scripts.ResultName;

public class SensitivityCatchWeightReferenceY7
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivityCatchWeightReferenceY7.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP};
    @Doc(value="Population")
    public Population param_pop;
    @Doc(value="Path of the CapturesPoids.csv file")
    public String param_referenceCatchWeightCSV = "";

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        ResultStorage resultStorage = simulation.getResultStorage();
        TimeStep lastStep = resultStorage.getLastStep();
        Double capturesWeight = 0.0;
        Double capturesWeightReference = 0.0;
        File referenceFile = new File(this.param_referenceCatchWeightCSV);
        ReverseFileReader reader = new ReverseFileReader(referenceFile);
        String line = reader.readLine();
        line = reader.readLine();
        Integer lastMonth = 0;
        while (line != null) {
            String[] items = line.split(";");
            if (lastMonth == 0) {
                lastMonth = Integer.parseInt(items[4]);
            }
            Integer month = Integer.parseInt(items[4]);
            if (items[0].equals(this.param_pop.getName()) && month > lastMonth - 12) {
                capturesWeightReference = capturesWeightReference + Double.parseDouble(items[5]);
            }
            line = reader.readLine();
        }
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            int i = 0;
            while (i < 12) {
                MatrixND matlastdate = resultStorage.getMatrix(new TimeStep(lastStep.getStep() - i), pop, ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP);
                capturesWeight = capturesWeight + matlastdate.sumAll();
                ++i;
            }
        }
        log.info((Object)("capturesWeight value : " + capturesWeight));
        log.info((Object)("capturesWeightReference value : " + capturesWeightReference));
        out.write(Double.toString(capturesWeight / capturesWeightReference));
    }

    public String getDescription() {
        return "Captures in weight for the last year for the popage population. Captures is the sum of zones, groups, metiers and strategies";
    }

    public String getExportFilename() {
        return "SensitivityCapturesWeightReferenceY7_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

