/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import scripts.SiMatrix;

public class EffortReduction
extends AbstractRule {
    private static Log log = LogFactory.getLog(EffortReduction.class);
    @Doc(value="Begin step")
    public TimeStep param_beginStep = new TimeStep(0);
    @Doc(value="End step")
    public TimeStep param_endStep = new TimeStep(59);
    @Doc(value="Pourcentage de reduction d effort applique.")
    public double param_PercentReduction = 0.5;
    protected boolean first = true;
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() {
        return "Reduce monthly effort of each strategy of the percent indicated";
    }

    public void init(SimulationContext context) throws Exception {
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        boolean result = true;
        if (step.before(this.param_beginStep)) {
            result = false;
        } else if (step.after(this.param_endStep)) {
            result = false;
        }
        if (result) {
            log.info((Object)"condition vraie");
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        if (this.first) {
            this.first = false;
            SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
            List<Strategy> strs = siMatrix.getStrategies(step);
            for (Strategy str : strs) {
                log.info((Object)("strategy evaluee : " + str.getName()));
                double propOld = str.getProportionSetOfVessels();
                double newProp = propOld * (1.0 - this.param_PercentReduction);
                str.setProportionSetOfVessels(newProp);
            }
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.first = true;
    }
}

