/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.GisService;
import fr.ifremer.echobase.services.service.spatial.SpatialDataService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Show
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Show.class);
    @Inject
    protected transient GisService gisService;
    @Inject
    protected transient SpatialDataService spatialDataService;
    @Inject
    protected transient EchoBaseUserPersistenceContext userPersistenceContext;
    @Inject
    private transient UserDbPersistenceService persistenceService;
    protected boolean spatialSupport;
    protected boolean spatialStructureFound;
    protected boolean gisSupport;
    protected boolean spatialDataToComputeExists;
    protected Map<String, String> voyages;

    public boolean isSpatialStructureFound() {
        return this.spatialStructureFound;
    }

    public boolean isSpatialSupport() {
        return this.spatialSupport;
    }

    public boolean isSpatialDataToComputeExists() {
        return this.spatialDataToComputeExists;
    }

    public boolean isGisSupport() {
        return this.gisSupport;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public String execute() throws Exception {
        this.spatialSupport = this.userPersistenceContext.isSpatialSupport();
        if (this.spatialSupport) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Db has spatial supports");
            }
            this.spatialStructureFound = this.userPersistenceContext.isSpatialStructureFound();
            if (this.spatialStructureFound) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Spatial structure found.");
                }
                this.spatialDataToComputeExists = this.spatialDataService.isSpatialDataToComputeExist();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Is there some spatial data to compute? " + this.spatialDataToComputeExists));
                }
                this.gisSupport = this.getEchoBaseApplicationContext().isGisSupport();
                if (this.gisSupport) {
                    JdbcConfiguration dbConf = this.getEchoBaseSession().getWorkingDbConfiguration();
                    this.gisService.registerWorkingDb(dbConf);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"Application does not support gis features.");
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Db has no spatial support.");
        }
        if (this.gisSupport && this.spatialSupport && this.spatialStructureFound && !this.spatialDataToComputeExists) {
            this.voyages = this.persistenceService.loadSortAndDecorate(Voyage.class);
        }
        return "success";
    }
}

