/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportAtlantos;

import fr.ifremer.echobase.services.service.atlantos.ExportAtlantosConfiguration;
import fr.ifremer.echobase.services.service.atlantos.ExportAtlantosService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Export
extends AbstractWaitAndExecAction<ExportAtlantosConfiguration, ExportAtlantosService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Export.class);

    public Export() {
        super(ExportAtlantosConfiguration.class, ExportAtlantosService.class);
    }

    protected void startAction(ExportAtlantosService service, ExportAtlantosConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start Atlantos export for voyage" + model.getVoyageId()));
        }
        service.doXmlExport(model);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.exportAtlantos.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.exportAtlantos.failed", new Object[0]);
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.exportAtlantos.resume", new Object[0]);
    }

    protected String getResultMessage(ExportAtlantosConfiguration model) {
        String result = this.t("echobase.message.exportAtantos.result", new Object[]{model.getExportFile().getName(), model.getActionTime()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + result));
        }
        return result;
    }
}

