/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.admin;

import fr.ifremer.coser.web.CoserWebConfig;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Map;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.SessionAware;
import org.nuiton.util.StringUtil;

@Result(name="success", type="redirect", location="index")
public class PerformLoginAction
extends CoserAction
implements SessionAware {
    private static final long serialVersionUID = -1576602720835497842L;
    protected String login;
    protected String password;
    private Map<String, Object> session;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public String execute() throws Exception {
        CoserWebConfig config = ServiceFactory.getCoserConfig();
        if (config.getAdminLogin().equals(this.login) && this.equalsSHA1Password(config, this.password)) {
            this.session.put("login", this.login);
            return "success";
        }
        this.addActionError("Invalid login/password");
        return "input";
    }

    protected boolean equalsSHA1Password(CoserWebConfig config, String password) {
        String sha1Password;
        String configSha1Password = config.getAdminPassword();
        boolean result = configSha1Password.equals(sha1Password = StringUtil.encodeSHA1((String)password));
        if (!result) {
            configSha1Password = StringUtil.encodeSHA1((String)configSha1Password);
            result = configSha1Password.equals(sha1Password);
        }
        return result;
    }
}

