/*
 * #%L
 * $Id: ZoneAction.java 797 2011-03-24 15:45:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/ZoneAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CommonZone;

/**
 * Affiche la liste des sous zones (zone).
 * 
 * @author chatellier
 * @version $Revision: 797 $
 * 
 * Last update : $Date: 2011-03-24 16:45:33 +0100 (Thu, 24 Mar 2011) $
 * By : $Author: chatellier $
 */
public class ZoneAction extends CommonZone {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        try {
            // renvoi la liste des id subzone-survey et leurs label associé
            zones = webService.getZoneForFacade(facade, false, true);
            zonesPictures = webService.getZonePictures();
            zonesMetaInfo = webService.getZoneMetaInfo();
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", ex);
        }

        return SUCCESS;
    }
}
