/*
 * #%L
 * $Id: LoginInterceptor.java 931 2011-12-23 15:13:08Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.3/coser-web/src/main/java/fr/ifremer/coser/web/actions/admin/LoginInterceptor.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.admin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.struts2.StrutsStatics;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;

/**
 * Authentication interceptor.
 * 
 * @author chatellier
 * @version $Revision: 931 $
 * 
 * Last update : $Date: 2011-12-23 16:13:08 +0100 (Fri, 23 Dec 2011) $
 * By : $Author: echatellier $
 */
public class LoginInterceptor implements Interceptor {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5760224375232019437L;

    /*
     * @see com.opensymphony.xwork2.interceptor.Interceptor#init()
     */
    @Override
    public void init() {

    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest) context.get(StrutsStatics.HTTP_REQUEST);
        HttpSession session = request.getSession(true);
        Object login = session.getAttribute("login");
        if (login == null) {
            return "redirect-login";
        } else {
            return invocation.invoke();
        }
    }

    /*
     * @see com.opensymphony.xwork2.interceptor.Interceptor#destroy()
     */
    @Override
    public void destroy() {

    }
}
