/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.pop;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpeciesAction
extends CoserAction {
    private static final long serialVersionUID = 1663244944108703571L;
    private static final Log log = LogFactory.getLog(SpeciesAction.class);
    protected String facade;
    protected String zone;
    protected Map<String, String> species;
    protected String zonePicture;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public String getZonePicture() {
        return this.zonePicture;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getZoneForFacade(this.facade, false).get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Looking for species for zone " + this.zone));
        }
        WebService webService = ServiceFactory.getWebService();
        try {
            this.species = webService.getSpecies(this.zone);
            this.zonePicture = (String)webService.getZonePictures().get(this.zone);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Species are : " + this.species));
            }
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone species", (Throwable)ex);
        }
        return "success";
    }
}

