/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.QuestionSearchBean;
import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;

public class QuestionsIndexationService
extends CoselmarSimpleServiceSupport {
    protected static final String QUESTION_ID_INDEX_PROPERTY = "questionId";
    protected static final String QUESTION_TITLE_INDEX_PROPERTY = "questionTitle";
    protected static final String QUESTION_SUMMARY_INDEX_PROPERTY = "questionSummary";
    protected static final String QUESTION_THEME_INDEX_PROPERTY = "questionTheme";
    protected static final String QUESTION_STATUS_INDEX_PROPERTY = "questionStatus";
    protected static final String QUESTION_PRIVACY_INDEX_PROPERTY = "questionPrivacy";
    protected static final String DOCUMENT_TYPE = "question";

    public void indexQuestion(QuestionBean question) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(QUESTION_ID_INDEX_PROPERTY, question.getId())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)query, null, (int)1000).scoreDocs;
        if (hits.length > 0) {
            Document doc = isearcher.doc(hits[0].doc);
            doc.removeField(QUESTION_TITLE_INDEX_PROPERTY);
            doc.add((IndexableField)new TextField(QUESTION_TITLE_INDEX_PROPERTY, question.getTitle(), Field.Store.YES));
            doc.removeField(QUESTION_SUMMARY_INDEX_PROPERTY);
            doc.add((IndexableField)new TextField(QUESTION_SUMMARY_INDEX_PROPERTY, question.getSummary(), Field.Store.YES));
            doc.removeFields(QUESTION_THEME_INDEX_PROPERTY);
            Set themes = question.getThemes();
            for (String theme : themes) {
                doc.add((IndexableField)new Field(QUESTION_THEME_INDEX_PROPERTY, theme, TextField.TYPE_STORED));
            }
            doc.removeField(QUESTION_STATUS_INDEX_PROPERTY);
            doc.add((IndexableField)new TextField(QUESTION_STATUS_INDEX_PROPERTY, question.getStatus(), Field.Store.YES));
            doc.removeField(QUESTION_PRIVACY_INDEX_PROPERTY);
            doc.add((IndexableField)new TextField(QUESTION_PRIVACY_INDEX_PROPERTY, question.getPrivacy(), Field.Store.YES));
            this.getLuceneUtils().getIndexWriter().updateDocument(new Term(QUESTION_ID_INDEX_PROPERTY, question.getId()), (Iterable)doc);
        } else {
            Document doc = new Document();
            doc.add((IndexableField)new StringField(QUESTION_ID_INDEX_PROPERTY, question.getId(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_TITLE_INDEX_PROPERTY, question.getTitle(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_SUMMARY_INDEX_PROPERTY, question.getSummary(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_STATUS_INDEX_PROPERTY, question.getStatus(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_PRIVACY_INDEX_PROPERTY, question.getPrivacy(), Field.Store.YES));
            Set themes = question.getThemes();
            for (String theme : themes) {
                doc.add((IndexableField)new Field(QUESTION_THEME_INDEX_PROPERTY, theme, TextField.TYPE_STORED));
            }
            doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
            this.getLuceneUtils().getIndexWriter().addDocument((Iterable)doc);
        }
        this.getLuceneUtils().getIndexWriter().commit();
        ireader.close();
    }

    public List<String> searchQuestion(QuestionSearchBean searchBean) throws IOException, ParseException {
        List keywords;
        String searchStatus;
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery fullQuery = new BooleanQuery();
        fullQuery.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        String searchPrivacy = searchBean.getPrivacy();
        if (StringUtils.isNotBlank((CharSequence)searchPrivacy)) {
            fullQuery.add((Query)new TermQuery(new Term(QUESTION_PRIVACY_INDEX_PROPERTY, searchPrivacy.toLowerCase())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((CharSequence)(searchStatus = searchBean.getStatus()))) {
            fullQuery.add((Query)new TermQuery(new Term(QUESTION_STATUS_INDEX_PROPERTY, searchStatus.toLowerCase())), BooleanClause.Occur.MUST);
        }
        if ((keywords = searchBean.getKeywords()) != null && !keywords.isEmpty()) {
            BooleanQuery keywordsQuery = new BooleanQuery();
            for (String text : keywords) {
                String[] words = text.replaceAll("[^a-zA-Z ]", "").toLowerCase().split(" ");
                BooleanQuery query = new BooleanQuery();
                PhraseQuery nameQuery = new PhraseQuery();
                PhraseQuery summaryQuery = new PhraseQuery();
                PhraseQuery authorsQuery = new PhraseQuery();
                for (String word : words) {
                    nameQuery.add(new Term(QUESTION_TITLE_INDEX_PROPERTY, word.toLowerCase()));
                    summaryQuery.add(new Term(QUESTION_SUMMARY_INDEX_PROPERTY, word.toLowerCase()));
                }
                query.add((Query)nameQuery, BooleanClause.Occur.SHOULD);
                query.add((Query)summaryQuery, BooleanClause.Occur.SHOULD);
                query.add((Query)authorsQuery, BooleanClause.Occur.SHOULD);
                query.add((Query)new TermQuery(new Term(QUESTION_THEME_INDEX_PROPERTY, text.toLowerCase())), BooleanClause.Occur.SHOULD);
                keywordsQuery.add((Query)query, BooleanClause.Occur.MUST);
            }
            fullQuery.add((Query)keywordsQuery, BooleanClause.Occur.MUST);
        }
        ScoreDoc[] hits = isearcher.search((Query)fullQuery, null, (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(QUESTION_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public void deleteQuestion(String documentId) throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(QUESTION_ID_INDEX_PROPERTY, documentId)), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    protected void cleanIndex() throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }
}

