/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserGroup;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.persistence.entity.Question;
import fr.ifremer.coselmar.persistence.entity.Status;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class QuestionAbstract
extends AbstractTopiaEntity
implements Question {
    protected String title;
    protected String type;
    protected String summary;
    protected Date submissionDate;
    protected Date deadline;
    protected Collection<String> theme;
    protected Date closingDate;
    protected Collection<String> externalExperts;
    protected boolean unavailable;
    protected String conclusion;
    protected CoselmarUserGroup participants;
    protected Set<Document> closingDocuments;
    protected Set<CoselmarUser> supervisors;
    protected Set<CoselmarUser> contributors;
    protected Set<Question> parents;
    protected Set<CoselmarUser> clients;
    protected Privacy privacy;
    protected Set<Document> relatedDocuments;
    protected Status status;
    private static final long serialVersionUID = 4049127716117635640L;

    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "title", String.class, (Object)this.title);
        visitor.visit((TopiaEntity)this, "type", String.class, (Object)this.type);
        visitor.visit((TopiaEntity)this, "summary", String.class, (Object)this.summary);
        visitor.visit((TopiaEntity)this, "submissionDate", Date.class, (Object)this.submissionDate);
        visitor.visit((TopiaEntity)this, "deadline", Date.class, (Object)this.deadline);
        visitor.visit((TopiaEntity)this, "theme", Collection.class, String.class, this.theme);
        visitor.visit((TopiaEntity)this, "closingDate", Date.class, (Object)this.closingDate);
        visitor.visit((TopiaEntity)this, "externalExperts", Collection.class, String.class, this.externalExperts);
        visitor.visit((TopiaEntity)this, "unavailable", Boolean.TYPE, (Object)this.unavailable);
        visitor.visit((TopiaEntity)this, "conclusion", String.class, (Object)this.conclusion);
        visitor.visit((TopiaEntity)this, "participants", CoselmarUserGroup.class, (Object)this.participants);
        visitor.visit((TopiaEntity)this, "closingDocuments", Set.class, Document.class, this.closingDocuments);
        visitor.visit((TopiaEntity)this, "supervisors", Set.class, CoselmarUser.class, this.supervisors);
        visitor.visit((TopiaEntity)this, "contributors", Set.class, CoselmarUser.class, this.contributors);
        visitor.visit((TopiaEntity)this, "parents", Set.class, Question.class, this.parents);
        visitor.visit((TopiaEntity)this, "clients", Set.class, CoselmarUser.class, this.clients);
        visitor.visit((TopiaEntity)this, "privacy", Privacy.class, (Object)this.privacy);
        visitor.visit((TopiaEntity)this, "relatedDocuments", Set.class, Document.class, this.relatedDocuments);
        visitor.visit((TopiaEntity)this, "status", Status.class, (Object)this.status);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        String result = this.title;
        return result;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        String result = this.type;
        return result;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getSummary() {
        String result = this.summary;
        return result;
    }

    @Override
    public void setSubmissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    @Override
    public Date getSubmissionDate() {
        Date result = this.submissionDate;
        return result;
    }

    @Override
    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    @Override
    public Date getDeadline() {
        Date result = this.deadline;
        return result;
    }

    @Override
    public void addTheme(String theme) {
        if (this.theme == null) {
            this.theme = new LinkedList<String>();
        }
        this.theme.add(theme);
    }

    @Override
    public void addAllTheme(Iterable<String> theme) {
        if (theme == null) {
            return;
        }
        for (String item : theme) {
            this.addTheme(item);
        }
    }

    @Override
    public void setTheme(Collection<String> theme) {
        this.theme = theme;
    }

    @Override
    public void removeTheme(String theme) {
        if (this.theme == null || !this.theme.remove(theme)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearTheme() {
        if (this.theme == null) {
            return;
        }
        this.theme.clear();
    }

    @Override
    public Collection<String> getTheme() {
        return this.theme;
    }

    @Override
    public int sizeTheme() {
        if (this.theme == null) {
            return 0;
        }
        return this.theme.size();
    }

    @Override
    public boolean isThemeEmpty() {
        int size = this.sizeTheme();
        return size == 0;
    }

    @Override
    public boolean isThemeNotEmpty() {
        boolean empty = this.isThemeEmpty();
        return !empty;
    }

    @Override
    public boolean containsTheme(String theme) {
        boolean contains = this.theme != null && this.theme.contains(theme);
        return contains;
    }

    @Override
    public void setClosingDate(Date closingDate) {
        this.closingDate = closingDate;
    }

    @Override
    public Date getClosingDate() {
        Date result = this.closingDate;
        return result;
    }

    @Override
    public void addExternalExperts(String externalExperts) {
        if (this.externalExperts == null) {
            this.externalExperts = new LinkedList<String>();
        }
        this.externalExperts.add(externalExperts);
    }

    @Override
    public void addAllExternalExperts(Iterable<String> externalExperts) {
        if (externalExperts == null) {
            return;
        }
        for (String item : externalExperts) {
            this.addExternalExperts(item);
        }
    }

    @Override
    public void setExternalExperts(Collection<String> externalExperts) {
        this.externalExperts = externalExperts;
    }

    @Override
    public void removeExternalExperts(String externalExperts) {
        if (this.externalExperts == null || !this.externalExperts.remove(externalExperts)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearExternalExperts() {
        if (this.externalExperts == null) {
            return;
        }
        this.externalExperts.clear();
    }

    @Override
    public Collection<String> getExternalExperts() {
        return this.externalExperts;
    }

    @Override
    public int sizeExternalExperts() {
        if (this.externalExperts == null) {
            return 0;
        }
        return this.externalExperts.size();
    }

    @Override
    public boolean isExternalExpertsEmpty() {
        int size = this.sizeExternalExperts();
        return size == 0;
    }

    @Override
    public boolean isExternalExpertsNotEmpty() {
        boolean empty = this.isExternalExpertsEmpty();
        return !empty;
    }

    @Override
    public boolean containsExternalExperts(String externalExperts) {
        boolean contains = this.externalExperts != null && this.externalExperts.contains(externalExperts);
        return contains;
    }

    @Override
    public void setUnavailable(boolean unavailable) {
        this.unavailable = unavailable;
    }

    @Override
    public boolean isUnavailable() {
        boolean result = this.unavailable;
        return result;
    }

    @Override
    public void setConclusion(String conclusion) {
        this.conclusion = conclusion;
    }

    @Override
    public String getConclusion() {
        String result = this.conclusion;
        return result;
    }

    @Override
    public void setParticipants(CoselmarUserGroup participants) {
        this.participants = participants;
    }

    @Override
    public CoselmarUserGroup getParticipants() {
        CoselmarUserGroup result = this.participants;
        return result;
    }

    @Override
    public void addClosingDocuments(Document closingDocuments) {
        if (this.closingDocuments == null) {
            this.closingDocuments = new HashSet<Document>();
        }
        this.closingDocuments.add(closingDocuments);
    }

    @Override
    public void addAllClosingDocuments(Iterable<Document> closingDocuments) {
        if (closingDocuments == null) {
            return;
        }
        for (Document item : closingDocuments) {
            this.addClosingDocuments(item);
        }
    }

    @Override
    public void setClosingDocuments(Set<Document> closingDocuments) {
        this.closingDocuments = closingDocuments;
    }

    @Override
    public void removeClosingDocuments(Document closingDocuments) {
        if (this.closingDocuments == null || !this.closingDocuments.remove(closingDocuments)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearClosingDocuments() {
        if (this.closingDocuments == null) {
            return;
        }
        this.closingDocuments.clear();
    }

    @Override
    public Set<Document> getClosingDocuments() {
        return this.closingDocuments;
    }

    @Override
    public Document getClosingDocumentsByTopiaId(String topiaId) {
        return (Document)TopiaEntityHelper.getEntityByTopiaId(this.closingDocuments, (String)topiaId);
    }

    @Override
    public Set<String> getClosingDocumentsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<Document> tmp = this.getClosingDocuments();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeClosingDocuments() {
        if (this.closingDocuments == null) {
            return 0;
        }
        return this.closingDocuments.size();
    }

    @Override
    public boolean isClosingDocumentsEmpty() {
        int size = this.sizeClosingDocuments();
        return size == 0;
    }

    @Override
    public boolean isClosingDocumentsNotEmpty() {
        boolean empty = this.isClosingDocumentsEmpty();
        return !empty;
    }

    @Override
    public boolean containsClosingDocuments(Document closingDocuments) {
        boolean contains = this.closingDocuments != null && this.closingDocuments.contains(closingDocuments);
        return contains;
    }

    @Override
    public void addSupervisors(CoselmarUser supervisors) {
        if (this.supervisors == null) {
            this.supervisors = new HashSet<CoselmarUser>();
        }
        this.supervisors.add(supervisors);
    }

    @Override
    public void addAllSupervisors(Iterable<CoselmarUser> supervisors) {
        if (supervisors == null) {
            return;
        }
        for (CoselmarUser item : supervisors) {
            this.addSupervisors(item);
        }
    }

    @Override
    public void setSupervisors(Set<CoselmarUser> supervisors) {
        this.supervisors = supervisors;
    }

    @Override
    public void removeSupervisors(CoselmarUser supervisors) {
        if (this.supervisors == null || !this.supervisors.remove(supervisors)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSupervisors() {
        if (this.supervisors == null) {
            return;
        }
        this.supervisors.clear();
    }

    @Override
    public Set<CoselmarUser> getSupervisors() {
        return this.supervisors;
    }

    @Override
    public CoselmarUser getSupervisorsByTopiaId(String topiaId) {
        return (CoselmarUser)TopiaEntityHelper.getEntityByTopiaId(this.supervisors, (String)topiaId);
    }

    @Override
    public Set<String> getSupervisorsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<CoselmarUser> tmp = this.getSupervisors();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSupervisors() {
        if (this.supervisors == null) {
            return 0;
        }
        return this.supervisors.size();
    }

    @Override
    public boolean isSupervisorsEmpty() {
        int size = this.sizeSupervisors();
        return size == 0;
    }

    @Override
    public boolean isSupervisorsNotEmpty() {
        boolean empty = this.isSupervisorsEmpty();
        return !empty;
    }

    @Override
    public boolean containsSupervisors(CoselmarUser supervisors) {
        boolean contains = this.supervisors != null && this.supervisors.contains(supervisors);
        return contains;
    }

    @Override
    public void addContributors(CoselmarUser contributors) {
        if (this.contributors == null) {
            this.contributors = new HashSet<CoselmarUser>();
        }
        this.contributors.add(contributors);
    }

    @Override
    public void addAllContributors(Iterable<CoselmarUser> contributors) {
        if (contributors == null) {
            return;
        }
        for (CoselmarUser item : contributors) {
            this.addContributors(item);
        }
    }

    @Override
    public void setContributors(Set<CoselmarUser> contributors) {
        this.contributors = contributors;
    }

    @Override
    public void removeContributors(CoselmarUser contributors) {
        if (this.contributors == null || !this.contributors.remove(contributors)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearContributors() {
        if (this.contributors == null) {
            return;
        }
        this.contributors.clear();
    }

    @Override
    public Set<CoselmarUser> getContributors() {
        return this.contributors;
    }

    @Override
    public CoselmarUser getContributorsByTopiaId(String topiaId) {
        return (CoselmarUser)TopiaEntityHelper.getEntityByTopiaId(this.contributors, (String)topiaId);
    }

    @Override
    public Set<String> getContributorsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<CoselmarUser> tmp = this.getContributors();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeContributors() {
        if (this.contributors == null) {
            return 0;
        }
        return this.contributors.size();
    }

    @Override
    public boolean isContributorsEmpty() {
        int size = this.sizeContributors();
        return size == 0;
    }

    @Override
    public boolean isContributorsNotEmpty() {
        boolean empty = this.isContributorsEmpty();
        return !empty;
    }

    @Override
    public boolean containsContributors(CoselmarUser contributors) {
        boolean contains = this.contributors != null && this.contributors.contains(contributors);
        return contains;
    }

    @Override
    public void addParents(Question parents) {
        if (this.parents == null) {
            this.parents = new HashSet<Question>();
        }
        this.parents.add(parents);
    }

    @Override
    public void addAllParents(Iterable<Question> parents) {
        if (parents == null) {
            return;
        }
        for (Question item : parents) {
            this.addParents(item);
        }
    }

    @Override
    public void setParents(Set<Question> parents) {
        this.parents = parents;
    }

    @Override
    public void removeParents(Question parents) {
        if (this.parents == null || !this.parents.remove(parents)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearParents() {
        if (this.parents == null) {
            return;
        }
        this.parents.clear();
    }

    @Override
    public Set<Question> getParents() {
        return this.parents;
    }

    @Override
    public Question getParentsByTopiaId(String topiaId) {
        return (Question)TopiaEntityHelper.getEntityByTopiaId(this.parents, (String)topiaId);
    }

    @Override
    public Set<String> getParentsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<Question> tmp = this.getParents();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeParents() {
        if (this.parents == null) {
            return 0;
        }
        return this.parents.size();
    }

    @Override
    public boolean isParentsEmpty() {
        int size = this.sizeParents();
        return size == 0;
    }

    @Override
    public boolean isParentsNotEmpty() {
        boolean empty = this.isParentsEmpty();
        return !empty;
    }

    @Override
    public boolean containsParents(Question parents) {
        boolean contains = this.parents != null && this.parents.contains(parents);
        return contains;
    }

    @Override
    public void addClients(CoselmarUser clients) {
        if (this.clients == null) {
            this.clients = new HashSet<CoselmarUser>();
        }
        this.clients.add(clients);
    }

    @Override
    public void addAllClients(Iterable<CoselmarUser> clients) {
        if (clients == null) {
            return;
        }
        for (CoselmarUser item : clients) {
            this.addClients(item);
        }
    }

    @Override
    public void setClients(Set<CoselmarUser> clients) {
        this.clients = clients;
    }

    @Override
    public void removeClients(CoselmarUser clients) {
        if (this.clients == null || !this.clients.remove(clients)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearClients() {
        if (this.clients == null) {
            return;
        }
        this.clients.clear();
    }

    @Override
    public Set<CoselmarUser> getClients() {
        return this.clients;
    }

    @Override
    public CoselmarUser getClientsByTopiaId(String topiaId) {
        return (CoselmarUser)TopiaEntityHelper.getEntityByTopiaId(this.clients, (String)topiaId);
    }

    @Override
    public Set<String> getClientsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<CoselmarUser> tmp = this.getClients();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeClients() {
        if (this.clients == null) {
            return 0;
        }
        return this.clients.size();
    }

    @Override
    public boolean isClientsEmpty() {
        int size = this.sizeClients();
        return size == 0;
    }

    @Override
    public boolean isClientsNotEmpty() {
        boolean empty = this.isClientsEmpty();
        return !empty;
    }

    @Override
    public boolean containsClients(CoselmarUser clients) {
        boolean contains = this.clients != null && this.clients.contains(clients);
        return contains;
    }

    @Override
    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @Override
    public Privacy getPrivacy() {
        Privacy result = this.privacy;
        return result;
    }

    @Override
    public void addRelatedDocuments(Document relatedDocuments) {
        if (this.relatedDocuments == null) {
            this.relatedDocuments = new HashSet<Document>();
        }
        this.relatedDocuments.add(relatedDocuments);
    }

    @Override
    public void addAllRelatedDocuments(Iterable<Document> relatedDocuments) {
        if (relatedDocuments == null) {
            return;
        }
        for (Document item : relatedDocuments) {
            this.addRelatedDocuments(item);
        }
    }

    @Override
    public void setRelatedDocuments(Set<Document> relatedDocuments) {
        this.relatedDocuments = relatedDocuments;
    }

    @Override
    public void removeRelatedDocuments(Document relatedDocuments) {
        if (this.relatedDocuments == null || !this.relatedDocuments.remove(relatedDocuments)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRelatedDocuments() {
        if (this.relatedDocuments == null) {
            return;
        }
        this.relatedDocuments.clear();
    }

    @Override
    public Set<Document> getRelatedDocuments() {
        return this.relatedDocuments;
    }

    @Override
    public Document getRelatedDocumentsByTopiaId(String topiaId) {
        return (Document)TopiaEntityHelper.getEntityByTopiaId(this.relatedDocuments, (String)topiaId);
    }

    @Override
    public Set<String> getRelatedDocumentsTopiaIds() {
        HashSet<String> topiaIds = new HashSet<String>();
        Set<Document> tmp = this.getRelatedDocuments();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRelatedDocuments() {
        if (this.relatedDocuments == null) {
            return 0;
        }
        return this.relatedDocuments.size();
    }

    @Override
    public boolean isRelatedDocumentsEmpty() {
        int size = this.sizeRelatedDocuments();
        return size == 0;
    }

    @Override
    public boolean isRelatedDocumentsNotEmpty() {
        boolean empty = this.isRelatedDocumentsEmpty();
        return !empty;
    }

    @Override
    public boolean containsRelatedDocuments(Document relatedDocuments) {
        boolean contains = this.relatedDocuments != null && this.relatedDocuments.contains(relatedDocuments);
        return contains;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public Status getStatus() {
        Status result = this.status;
        return result;
    }
}

