package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.AbstractCoselmarTopiaDao;
import fr.ifremer.coselmar.persistence.CoselmarEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Feb 06 11:30:35 UTC 2015")
public abstract class GeneratedCoselmarUserGroupTopiaDao<E extends CoselmarUserGroup> extends AbstractCoselmarTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) CoselmarUserGroup.class;
    }

    @Override
    public CoselmarEntityEnum getTopiaEntityEnum() {
        return CoselmarEntityEnum.CoselmarUserGroup;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            QuestionTopiaDao dao = topiaDaoSupplier
                    .getDao(Question.class, QuestionTopiaDao.class);
            List<Question> list = dao
                    .forProperties(Question.PROPERTY_PARTICIPANTS, entity)
                    .findAll();
            for (Question item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getParticipants())) {
                    item.setParticipants(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUserGroup.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUserGroup.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQuestionIn(Collection<Question> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUserGroup.PROPERTY_QUESTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQuestionEquals(Question v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUserGroup.PROPERTY_QUESTION, v);
        return result;
    }

    @Deprecated
    public E findByQuestion(Question v) {
        return forQuestionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQuestion(Question v) {
        return forQuestionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMembersContains(CoselmarUser v) {
        return forContains(CoselmarUserGroup.PROPERTY_MEMBERS, v);
    }

    @Deprecated
    public E findContainsMembers(CoselmarUser v) {
        return forMembersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMembers(CoselmarUser v) {
        return forMembersContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Document.class) {
            DocumentTopiaDao dao =
                topiaDaoSupplier.getDao(Document.class, DocumentTopiaDao.class);
            tmp = dao.forRestrictedListContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forParticipantsEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Document.class, entity);
        if (!list.isEmpty()) {
            result.put(Document.class, list);
        }

        list = findUsages(Question.class, entity);
        if (!list.isEmpty()) {
            result.put(Question.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedCoselmarUserGroupTopiaDao<E extends CoselmarUserGroup>
