package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 11 16:13:01 UTC 2014")
public abstract class DocumentAbstract extends AbstractTopiaEntity implements Document {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : depositDate
     */
    protected Date depositDate;

    /**
     * Nom de l'attribut en BD : keywords
     */
    protected Collection<String> keywords;

    /**
     * Nom de l'attribut en BD : mimeType
     */
    protected String mimeType;

    /**
     * Nom de l'attribut en BD : copyright
     */
    protected String Copyright;

    /**
     * Nom de l'attribut en BD : authors
     */
    protected String Authors;

    /**
     * Nom de l'attribut en BD : license
     */
    protected String License;

    /**
     * Nom de l'attribut en BD : language
     */
    protected String language;

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : publicationDate
     */
    protected Date publicationDate;

    /**
     * Nom de l'attribut en BD : summary
     */
    protected String summary;

    /**
     * Nom de l'attribut en BD : withFile
     */
    protected boolean withFile;

    /**
     * Nom de l'attribut en BD : externalUrl
     */
    protected String externalUrl;

    /**
     * Nom de l'attribut en BD : privacy
     */
    protected Privacy privacy;

    /**
     * Nom de l'attribut en BD : owner
     */
    protected CoselmarUser owner;

    /**
     * Nom de l'attribut en BD : restrictedList
     */
    protected Set<CoselmarUserGroup> restrictedList;

    private static final long serialVersionUID = 3691042058337018675L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DEPOSIT_DATE, Date.class, depositDate);
        visitor.visit(this, PROPERTY_KEYWORDS, Collection.class, String.class, keywords);
        visitor.visit(this, PROPERTY_MIME_TYPE, String.class, mimeType);
        visitor.visit(this, PROPERTY_COPYRIGHT, String.class, Copyright);
        visitor.visit(this, PROPERTY_AUTHORS, String.class, Authors);
        visitor.visit(this, PROPERTY_LICENSE, String.class, License);
        visitor.visit(this, PROPERTY_LANGUAGE, String.class, language);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_PUBLICATION_DATE, Date.class, publicationDate);
        visitor.visit(this, PROPERTY_SUMMARY, String.class, summary);
        visitor.visit(this, PROPERTY_WITH_FILE, boolean.class, withFile);
        visitor.visit(this, PROPERTY_EXTERNAL_URL, String.class, externalUrl);
        visitor.visit(this, PROPERTY_PRIVACY, Privacy.class, privacy);
        visitor.visit(this, PROPERTY_OWNER, CoselmarUser.class, owner);
        visitor.visit(this, PROPERTY_RESTRICTED_LIST, Set.class, CoselmarUserGroup.class, restrictedList);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setDepositDate(Date depositDate) {
        this.depositDate = depositDate;
    }

    @Override
    public Date getDepositDate() {
        Date result = this.depositDate;
        return result;
    }

    @Override
    public void addKeywords(String keywords) {
        if (this.keywords == null) {
            this.keywords = new LinkedList<String>();
        }
        this.keywords.add(keywords);
    }

    @Override
    public void addAllKeywords(Collection<String> keywords) {
        if (keywords == null) {
            return;
        }
        for (String item : keywords) {
            addKeywords(item);
        }
    }

    @Override
    public void setKeywords(Collection<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public void removeKeywords(String keywords) {
        if (this.keywords == null || !this.keywords.remove(keywords)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearKeywords() {
        if (this.keywords == null) {
            return;
        }
        this.keywords.clear();
    }

    @Override
    public Collection<String> getKeywords() {
        return keywords;
    }

    @Override
    public int sizeKeywords() {
        if (keywords == null) {
            return 0;
        }
        return keywords.size();
    }

    @Override
    public boolean isKeywordsEmpty() {
        int size = sizeKeywords();
        return size == 0;
    }

    @Override
    public boolean isKeywordsNotEmpty() {
        boolean empty = isKeywordsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsKeywords(String keywords) {
        boolean contains = this.keywords !=null && this.keywords.contains(keywords);
        return contains;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getMimeType() {
        String result = this.mimeType;
        return result;
    }

    @Override
    public void setCopyright(String Copyright) {
        this.Copyright = Copyright;
    }

    @Override
    public String getCopyright() {
        String result = this.Copyright;
        return result;
    }

    @Override
    public void setAuthors(String Authors) {
        this.Authors = Authors;
    }

    @Override
    public String getAuthors() {
        String result = this.Authors;
        return result;
    }

    @Override
    public void setLicense(String License) {
        this.License = License;
    }

    @Override
    public String getLicense() {
        String result = this.License;
        return result;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getLanguage() {
        String result = this.language;
        return result;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        String result = this.type;
        return result;
    }

    @Override
    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
    }

    @Override
    public Date getPublicationDate() {
        Date result = this.publicationDate;
        return result;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getSummary() {
        String result = this.summary;
        return result;
    }

    @Override
    public void setWithFile(boolean withFile) {
        this.withFile = withFile;
    }

    @Override
    public boolean isWithFile() {
        boolean result = this.withFile;
        return result;
    }

    @Override
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @Override
    public String getExternalUrl() {
        String result = this.externalUrl;
        return result;
    }

    @Override
    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @Override
    public Privacy getPrivacy() {
        Privacy result = this.privacy;
        return result;
    }

    @Override
    public void setOwner(CoselmarUser owner) {
        this.owner = owner;
    }

    @Override
    public CoselmarUser getOwner() {
        CoselmarUser result = this.owner;
        return result;
    }

    @Override
    public void addRestrictedList(CoselmarUserGroup restrictedList) {
        if (this.restrictedList == null) {
            this.restrictedList = new HashSet<CoselmarUserGroup>();
        }
        this.restrictedList.add(restrictedList);
    }

    @Override
    public void addAllRestrictedList(Set<CoselmarUserGroup> restrictedList) {
        if (restrictedList == null) {
            return;
        }
        for (CoselmarUserGroup item : restrictedList) {
            addRestrictedList(item);
        }
    }

    @Override
    public void setRestrictedList(Set<CoselmarUserGroup> restrictedList) {
        this.restrictedList = restrictedList;
    }

    @Override
    public void removeRestrictedList(CoselmarUserGroup restrictedList) {
        if (this.restrictedList == null || !this.restrictedList.remove(restrictedList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRestrictedList() {
        if (this.restrictedList == null) {
            return;
        }
        this.restrictedList.clear();
    }

    @Override
    public Set<CoselmarUserGroup> getRestrictedList() {
        return restrictedList;
    }

    @Override
    public CoselmarUserGroup getRestrictedListByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(restrictedList, topiaId);
    }

    @Override
    public Set<String> getRestrictedListTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.CoselmarUserGroup> tmp = getRestrictedList();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRestrictedList() {
        if (restrictedList == null) {
            return 0;
        }
        return restrictedList.size();
    }

    @Override
    public boolean isRestrictedListEmpty() {
        int size = sizeRestrictedList();
        return size == 0;
    }

    @Override
    public boolean isRestrictedListNotEmpty() {
        boolean empty = isRestrictedListEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRestrictedList(CoselmarUserGroup restrictedList) {
        boolean contains = this.restrictedList !=null && this.restrictedList.contains(restrictedList);
        return contains;
    }

} //DocumentAbstract
