/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.debux.webmotion.server.call.HttpContext;

public final class CoselmarRestUtil {
    public static final String HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";

    private CoselmarRestUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void prepareResponse(HttpContext context) {
        HttpServletResponse response = context.getResponse();
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    public static void addOptionCorsHeaders(HttpContext context) {
        String requestHeaders = context.getHeader(HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        if (StringUtils.isNotBlank((CharSequence)requestHeaders)) {
            context.getResponse().addHeader(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, requestHeaders);
        }
    }
}

