/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;

public class DocumentsIndexationService
extends CoselmarSimpleServiceSupport {
    protected static final String DOCUMENT_ID_INDEX_PROPERTY = "documentId";
    protected static final String DOCUMENT_NAME_INDEX_PROPERTY = "documentName";
    protected static final String DOCUMENT_AUTHORS_INDEX_PROPERTY = "documentAuthors";
    protected static final String DOCUMENT_SUMMARY_INDEX_PROPERTY = "documentSummary";
    protected static final String DOCUMENT_KEYWORD_INDEX_PROPERTY = "documentKeyword";
    protected static final String DOCUMENT_TYPE = "document";

    public void indexDocument(DocumentBean document) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(DOCUMENT_ID_INDEX_PROPERTY, document.getId(), Field.Store.YES));
        doc.add((IndexableField)new TextField(DOCUMENT_NAME_INDEX_PROPERTY, document.getName(), Field.Store.YES));
        doc.add((IndexableField)new TextField(DOCUMENT_AUTHORS_INDEX_PROPERTY, document.getAuthors(), Field.Store.YES));
        doc.add((IndexableField)new TextField(DOCUMENT_SUMMARY_INDEX_PROPERTY, document.getSummary(), Field.Store.YES));
        doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
        Set keywords = document.getKeywords();
        if (keywords != null) {
            for (String keyword : keywords) {
                doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_INDEX_PROPERTY, keyword, TextField.TYPE_STORED));
            }
        }
        this.getLuceneUtils().getIndexWriter().addDocument((Iterable)doc);
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public List<String> searchDocuments(String text) throws IOException, ParseException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        String[] words = text.split(" ");
        BooleanQuery query = new BooleanQuery();
        PhraseQuery nameQuery = new PhraseQuery();
        PhraseQuery summaryQuery = new PhraseQuery();
        PhraseQuery authorsQuery = new PhraseQuery();
        for (String word : words) {
            nameQuery.add(new Term(DOCUMENT_NAME_INDEX_PROPERTY, word.toLowerCase()));
            summaryQuery.add(new Term(DOCUMENT_SUMMARY_INDEX_PROPERTY, word.toLowerCase()));
            authorsQuery.add(new Term(DOCUMENT_AUTHORS_INDEX_PROPERTY, word.toLowerCase()));
        }
        query.add((Query)nameQuery, BooleanClause.Occur.SHOULD);
        query.add((Query)summaryQuery, BooleanClause.Occur.SHOULD);
        query.add((Query)authorsQuery, BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term(DOCUMENT_KEYWORD_INDEX_PROPERTY, text)), BooleanClause.Occur.SHOULD);
        BooleanQuery fullQuery = new BooleanQuery();
        fullQuery.add((Query)query, BooleanClause.Occur.MUST);
        fullQuery.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)fullQuery, null, (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(DOCUMENT_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public List<String> searchDocuments(List<String> texts) throws IOException, ParseException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery keywordsQuery = new BooleanQuery();
        for (String text : texts) {
            String[] words = text.split(" ");
            BooleanQuery query = new BooleanQuery();
            PhraseQuery nameQuery = new PhraseQuery();
            PhraseQuery summaryQuery = new PhraseQuery();
            PhraseQuery authorsQuery = new PhraseQuery();
            for (String word : words) {
                nameQuery.add(new Term(DOCUMENT_NAME_INDEX_PROPERTY, word.toLowerCase()));
                summaryQuery.add(new Term(DOCUMENT_SUMMARY_INDEX_PROPERTY, word.toLowerCase()));
                authorsQuery.add(new Term(DOCUMENT_AUTHORS_INDEX_PROPERTY, word.toLowerCase()));
            }
            query.add((Query)nameQuery, BooleanClause.Occur.SHOULD);
            query.add((Query)summaryQuery, BooleanClause.Occur.SHOULD);
            query.add((Query)authorsQuery, BooleanClause.Occur.SHOULD);
            query.add((Query)new TermQuery(new Term(DOCUMENT_KEYWORD_INDEX_PROPERTY, text)), BooleanClause.Occur.SHOULD);
            keywordsQuery.add((Query)query, BooleanClause.Occur.MUST);
        }
        BooleanQuery fullQuery = new BooleanQuery();
        fullQuery.add((Query)keywordsQuery, BooleanClause.Occur.MUST);
        fullQuery.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)fullQuery, null, (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(DOCUMENT_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public void updateDocument(DocumentBean document) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(DOCUMENT_ID_INDEX_PROPERTY, document.getId())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)query, null, (int)1000).scoreDocs;
        if (hits.length > 0) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField(DOCUMENT_ID_INDEX_PROPERTY, document.getId(), Field.Store.YES));
            doc.add((IndexableField)new TextField(DOCUMENT_NAME_INDEX_PROPERTY, document.getName(), Field.Store.YES));
            doc.add((IndexableField)new TextField(DOCUMENT_AUTHORS_INDEX_PROPERTY, document.getAuthors(), Field.Store.YES));
            doc.add((IndexableField)new TextField(DOCUMENT_SUMMARY_INDEX_PROPERTY, document.getSummary(), Field.Store.YES));
            Set keywords = document.getKeywords();
            if (keywords != null) {
                for (String keyword : keywords) {
                    doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_INDEX_PROPERTY, keyword, TextField.TYPE_STORED));
                }
            }
            doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
            this.getLuceneUtils().getIndexWriter().updateDocument(new Term(DOCUMENT_ID_INDEX_PROPERTY, document.getId()), (Iterable)doc);
            this.getLuceneUtils().getIndexWriter().commit();
        }
        ireader.close();
    }

    public void deleteDocument(String documentId) throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(DOCUMENT_ID_INDEX_PROPERTY, documentId)), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    protected void cleanIndex() throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }
}

