/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.converter;

import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserGroup;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserImpl;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Question;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaIdFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeanEntityConverter {
    public static DocumentBean toBean(TopiaIdFactory idFactory, Document document) {
        String lightId = idFactory.getRandomPart(document.getTopiaId());
        Date depositeDate = document.getDepositDate();
        Date publicationDate = document.getPublicationDate();
        CoselmarUser documentOwner = document.getOwner();
        String owner = "N/A";
        String ownerId = "N/A";
        if (documentOwner != null) {
            String firstname = documentOwner.getFirstname();
            String lastname = documentOwner.getName();
            owner = StringUtils.defaultString((String)firstname) + StringUtils.defaultString((String)lastname);
            ownerId = idFactory.getRandomPart(documentOwner.getTopiaId());
        }
        return new DocumentBean(lightId, document.getName(), owner, ownerId, document.getPrivacy().name(), depositeDate, document.getKeywords(), document.getType(), document.getSummary(), document.getLanguage(), publicationDate, document.getAuthors(), document.getLicense(), document.getCopyright(), document.isWithFile(), document.getMimeType(), document.getExternalUrl(), document.getComment(), document.getFileName());
    }

    public static UserBean toBean(String lightId, CoselmarUser user) {
        return new UserBean(lightId, user.getFirstname(), user.getName(), user.getMail(), user.getPhoneNumber(), user.getRole().name(), user.getQualification(), user.getOrganization(), user.isActive());
    }

    public static CoselmarUser fromBean(UserBean userBean) {
        CoselmarUserImpl user = new CoselmarUserImpl();
        user.setFirstname(userBean.getFirstName());
        user.setName(userBean.getName());
        user.setMail(userBean.getMail());
        String role = userBean.getRole();
        if (StringUtils.isNotBlank((CharSequence)role)) {
            user.setRole(CoselmarUserRole.valueOf((String)role));
        }
        user.setQualification(userBean.getQualification());
        user.setOrganization(userBean.getOrganization());
        user.setActive(userBean.isActive());
        user.setPhoneNumber(userBean.getPhoneNumber());
        return user;
    }

    public static QuestionBean toBean(TopiaIdFactory idFactory, Question question) {
        Set parents;
        Set relatedDocuments;
        Set contributors;
        Set clients;
        Set supervisors;
        CoselmarUserGroup participants;
        Date closingDate;
        Date deadline;
        Date submissionDate;
        QuestionBean result = new QuestionBean();
        result.setId(idFactory.getRandomPart(question.getTopiaId()));
        result.setTitle(question.getTitle());
        result.setSummary(question.getSummary());
        result.setType(question.getType());
        result.setPrivacy(question.getPrivacy().name());
        result.setStatus(question.getStatus().name());
        Collection theme = question.getTheme();
        if (theme != null && !theme.isEmpty()) {
            result.setThemes(new HashSet(theme));
        }
        if ((submissionDate = question.getSubmissionDate()) != null) {
            result.setSubmissionDate(new Date(submissionDate.getTime()));
        }
        if ((deadline = question.getDeadline()) != null) {
            result.setDeadline(new Date(deadline.getTime()));
        }
        if ((closingDate = question.getClosingDate()) != null) {
            result.setClosingDate(new Date(closingDate.getTime()));
        }
        if ((participants = question.getParticipants()) != null && participants.getMembers() != null) {
            for (CoselmarUser participant : participants.getMembers()) {
                String lightId = idFactory.getRandomPart(participant.getTopiaId());
                UserBean participantBean = BeanEntityConverter.toBean((String)lightId, (CoselmarUser)participant);
                result.addParticipant(participantBean);
            }
        }
        if ((supervisors = question.getSupervisors()) != null && !supervisors.isEmpty()) {
            for (CoselmarUser supervisor : supervisors) {
                String lightId = idFactory.getRandomPart(supervisor.getTopiaId());
                UserBean supervisorBean = BeanEntityConverter.toBean((String)lightId, (CoselmarUser)supervisor);
                result.addSupervisor(supervisorBean);
            }
        }
        if ((clients = question.getClients()) != null && !clients.isEmpty()) {
            for (CoselmarUser client : clients) {
                String lightId = idFactory.getRandomPart(client.getTopiaId());
                UserBean clientBean = BeanEntityConverter.toBean((String)lightId, (CoselmarUser)client);
                result.addClient(clientBean);
            }
        }
        if ((contributors = question.getContributors()) != null && !contributors.isEmpty()) {
            for (CoselmarUser contributor : contributors) {
                String lightId = idFactory.getRandomPart(contributor.getTopiaId());
                UserBean contributorBean = BeanEntityConverter.toBean((String)lightId, (CoselmarUser)contributor);
                result.addContributor(contributorBean);
            }
        }
        if ((relatedDocuments = question.getRelatedDocuments()) != null && !relatedDocuments.isEmpty()) {
            for (Document relatedDocument : relatedDocuments) {
                DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)idFactory, (Document)relatedDocument);
                result.addRelatedDocument(documentBean);
            }
        }
        if ((parents = question.getParents()) != null && !parents.isEmpty()) {
            for (Question parent : parents) {
                QuestionBean questionBean = BeanEntityConverter.toLightBean((TopiaIdFactory)idFactory, (Question)parent);
                result.addParent(questionBean);
            }
        }
        result.setConclusion(question.getConclusion());
        Set closingDocuments = question.getClosingDocuments();
        if (closingDocuments != null && !closingDocuments.isEmpty()) {
            for (Document relatedDocument : closingDocuments) {
                String lightId = idFactory.getRandomPart(relatedDocument.getTopiaId());
                DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)idFactory, (Document)relatedDocument);
                result.addClosingDocument(documentBean);
            }
        }
        result.setRestricted(question.isUnavailable());
        return result;
    }

    public static QuestionBean toLightBean(TopiaIdFactory idFactory, Question question) {
        Set parents;
        Set closingDocuments;
        Date closingDate;
        Date deadline;
        Date submissionDate;
        QuestionBean result = new QuestionBean();
        result.setId(idFactory.getRandomPart(question.getTopiaId()));
        result.setTitle(question.getTitle());
        result.setSummary(question.getSummary());
        result.setType(question.getType());
        result.setPrivacy(question.getPrivacy().name());
        result.setStatus(question.getStatus().name());
        Collection theme = question.getTheme();
        if (theme != null && !theme.isEmpty()) {
            result.setThemes(new HashSet(theme));
        }
        if ((submissionDate = question.getSubmissionDate()) != null) {
            result.setSubmissionDate(new Date(submissionDate.getTime()));
        }
        if ((deadline = question.getDeadline()) != null) {
            result.setDeadline(new Date(deadline.getTime()));
        }
        if ((closingDate = question.getClosingDate()) != null) {
            result.setClosingDate(new Date(closingDate.getTime()));
            result.setConclusion(question.getConclusion());
        }
        if ((closingDocuments = question.getClosingDocuments()) != null && !closingDocuments.isEmpty()) {
            for (Document relatedDocument : closingDocuments) {
                String lightId = idFactory.getRandomPart(relatedDocument.getTopiaId());
                DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)idFactory, (Document)relatedDocument);
                result.addClosingDocument(documentBean);
            }
        }
        if ((parents = question.getParents()) != null && !parents.isEmpty()) {
            for (Question parent : parents) {
                QuestionBean questionBean = BeanEntityConverter.toLightBean((TopiaIdFactory)idFactory, (Question)parent);
                result.addParent(questionBean);
            }
        }
        result.setRestricted(question.isUnavailable());
        return result;
    }
}

