/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.thesaurus;

import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.search.SearchHandler;

/**
 * @author letellier
 */
public class ThesaurusHandler {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(ThesaurusHandler.class);

    /**
     * Init all thesaurus panel to attach to offer edit panel
     *
     * @param ui OfferEditUI
     */
    public void initThesaurus(OfferEditUI ui) {

        JList propositionList = ui.getPropositionList();
        Form form = ui.getData();
        JPanel thesaurusPanel = ui.getThesaurus();

        // Remove all thesaurus panels
        thesaurusPanel.removeAll();

        VradiDataProvider dataProvider = new VradiDataProvider();

        // Create thesaurus manager
        ThesaurusSelectionManager manager = new ThesaurusSelectionManager(propositionList, form);

        // Display root thesaurus UI
        ThesaurusTreeHelper rootHelper = new ThesaurusTreeHelper(dataProvider);
        openThesaurusUI(ui, thesaurusPanel, manager, rootHelper, false);

        // Create helpers for saved root thesaurus
        List<String> rootThesaurusIds = VradiHelper.getVradiListRootThesaurus();
        List<RootThesaurus> savedRootThesauruses = ThesaurusDataHelper.restoreRootThesaurus(rootThesaurusIds);
        for (RootThesaurus savedRootThesaurus : savedRootThesauruses) {
            if (savedRootThesaurus != null) {
                ThesaurusTreeHelper helper = new ThesaurusTreeHelper(dataProvider, savedRootThesaurus);
                openThesaurusUI(ui, thesaurusPanel, manager, helper, true);
            }
        }

        // Create helpers for saved thesaurus
        List<String> thesaurusIds = VradiHelper.getVradiListThesaurus();
        List<Thesaurus> savedThesauruses = ThesaurusDataHelper.restoreThesaurus(thesaurusIds);
        for (Thesaurus savedThesaurus : savedThesauruses) {
            if (savedThesaurus != null) {
                ThesaurusTreeHelper helper = new ThesaurusTreeHelper(dataProvider, savedThesaurus);
                openThesaurusUI(ui, thesaurusPanel, manager, helper, true);
            }
        }

        // Update size thesaurus
        ui.updateThesaurusSize();
    }

    protected void openThesaurusUI(JAXXContext context, JPanel thesaurusPanel, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        thesaurusPanel.add(new ThesaurusUI(context, manager, helper, deletable));
    }

    /**
     * Add thesaurus panel removable in offerEdit and save it in properties
     *
     * @param context jaxx context
     * @param manager thesaurus selection manager
     * @param path    path of thesaurus to add
     */
    public void newThesaurusUI(JAXXContext context, ThesaurusSelectionManager manager, TreePath path) {
        if (path == null) {
            return;
        }
        // Get selected thesaurus
        VradiTreeNode parentNode = (VradiTreeNode) path.getLastPathComponent();
        if (parentNode == null) {
            return;
        }

        ThesaurusTreeHelper newHelper;

        RootThesaurus rootThesaurus = getRootThesaurus(parentNode);
        if (rootThesaurus != null) {
            newHelper = new ThesaurusTreeHelper(manager.getDataProvider(), rootThesaurus);

            // Save in properties
            VradiHelper.addVradiListRootThesaurus(rootThesaurus);

        } else {
            Thesaurus thesaurus = getThesaurus(parentNode);
            newHelper = new ThesaurusTreeHelper(manager.getDataProvider(), thesaurus);

            // Save in properties
            VradiHelper.addVradiListThesaurus(thesaurus);
        }

        openThesaurusUI(context, getThesaurusContainer(context), manager, newHelper, true);

        getEditUI(context).updateThesaurusSize();

    }

    /**
     * Remove thesaurus ui and save it in properties
     *
     * @param context to removed
     */
    public void closeThesaurus(JAXXContext context) {

        ThesaurusUI thesaurusUI = getUI(context);
        OfferEditUI ui = thesaurusUI.getParentContainer(OfferEditUI.class);
        getThesaurusContainer(context).remove(thesaurusUI);

        // Save in properties
        VradiTreeNode rootNode = thesaurusUI.helper.getRootNode();

        Thesaurus thesaurus = getThesaurus(rootNode);
        if (thesaurus != null) {
            VradiHelper.removeVradiListThesaurus(thesaurus);
        } else {
            RootThesaurus rootThesaurus = getRootThesaurus(rootNode);
            VradiHelper.removeVradiListRootThesaurus(rootThesaurus);
        }

        ui.updateThesaurusSize();
    }

    /**
     * Add criteria in search panel and save it in properties
     *
     * @param context jaxx context
     * @param helper  helper concerned
     * @param path    path of thesaurus to transform to criteria
     */
    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = getListUI(context);

        // Get selected thesaurus
        VradiTreeNode parentNode = getParentNode(helper, path);

        Thesaurus thesaurus = getThesaurus(parentNode);

        // Adding to offerListUI
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus);

        ui.validate();
    }

    /**
     * Return selected node
     *
     * @param helper  helper of tree  
     * @return selected node
     */
    protected VradiTreeNode getSelectedNode(ThesaurusTreeHelper helper) {

        // Get selected thesaurus
        VradiTreeNode selectedNode = helper.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    protected RootThesaurus getRootThesaurus(VradiTreeNode node) {
        Class<?> internalClass = node.getInternalClass();
        if (!internalClass.equals(RootThesaurus.class)) {
            return null;
        }
        String id = node.getId();

        return ThesaurusDataHelper.restoreRootThesaurus(id);
    }

    public String getNamePath(VradiTreeNode node) {
        if (node == null) {
            return "";
        }
        // If its root node of all root thesaurus
        if (node.isStringNode()) {
            return "";
        }
        String id = node.getId();
        Class<?> internalClass = node.getInternalClass();
        if (internalClass.equals(RootThesaurus.class)) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(id);
            return rootThesaurus.getName();
        }
        Thesaurus thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
        return ThesaurusDataHelper.getNamePath(thesaurus, "/");
    }

    protected Thesaurus getThesaurus(VradiTreeNode node) {
        Class<?> internalClass = node.getInternalClass();
        if (!internalClass.equals(Thesaurus.class)) {
            return null;
        }
        String id = node.getId();

        return ThesaurusDataHelper.restoreThesaurus(id);
    }

    /**
     * Find thesaurusUI in context
     *
     * @param context jaxx context
     * @return thesaurusUI in context
     */
    public ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI) context;
        }
        return null;
    }

    /**
     * Get thesaurus panel from OfferEditUI
     *
     * @param context jaxx context
     * @return thesaurus panel
     */
    protected JPanel getThesaurusContainer(JAXXContext context) {
        return getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    /**
     * Get OfferEditUI
     *
     * @param context jaxx context
     * @return offer edit panel
     */
    protected OfferEditUI getEditUI(JAXXContext context) {
        return getUI(context).getParentUI();
    }

    /**
     * Get OfferListUI
     *
     * @param context jaxx context
     * @return offer list panel
     */
    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    /**
     * Get parent node
     *
     * @param helper thesaurus helper
     * @param path   concerned path
     * @return parent node
     */
    protected VradiTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return helper.getRootNode();
        } else {
            return (VradiTreeNode) path.getLastPathComponent();
        }
    }

    /**
     * Refresh all thesaurus displayed
     *
     * @param context
     */
//    public void refreshAllThesaurus(JAXXContext context) {
//        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
//        if (log.isDebugEnabled()) {
//            log.debug("Refresh ui : " + (editUIs == null ? "is null" : editUIs.size()));
//        }
//        if (editUIs != null) {
//            for (OfferEditUI editUI : editUIs) {
//                if (log.isDebugEnabled()) {
//                    log.debug("Refresh ui : " + editUI.getData().getObjet());
//                }
//                initThesaurus(context, editUI);
//            }
//        }
//    }

    /**
     * Refresh all other thesaurus displayed
     *
     * @param context
     * @param ui
     */
//    public void refreshOtherThesaurus(JAXXContext context, OfferEditUI ui) {
//        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
//        if (log.isDebugEnabled()) {
//            log.debug("Refresh ui : " + (editUIs == null ? "is null" : editUIs.size()));
//        }
//        if (editUIs != null) {
//            for (OfferEditUI editUI : editUIs) {
//                if (!editUI.equals(ui)){
//                    if (log.isDebugEnabled()) {
//                        log.debug("Refresh ui : " + editUI.getData().getObjet());
//                    }
//                    initThesaurus(context, editUI);
//                }
//            }
//        }
//    }

}

