/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.renderers;


import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import javax.swing.*;
import java.awt.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * User: letellier
 */
public class SendingRenderer extends DefaultListCellRenderer implements WikittyServiceListener {

    protected Map<String, String> renderCache = new HashMap<String, String>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        WikittyProxy proxy = VradiService.getWikittyProxy();

        Sending sending = (Sending)value;

        String wikittyId = sending.getWikittyId();

        // Search in cache
        if (renderCache.containsKey(wikittyId)) {
            return super.getListCellRendererComponent(list, renderCache.get(wikittyId), index, isSelected, cellHasFocus);
        }

        String text = "";
        String userId = sending.getUser();
        if (userId != null){
            User user = proxy.restore(User.class, userId);
            Client client = proxy.restore(Client.class, user.getClient());
            text = client.getName() + " - " + user.getName();
        }

        // Put in cache
        renderCache.put(wikittyId, text);

        return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);

            // Sending
            if (wikittyExtensions.contains(Sending.EXT_SENDING)) {

                // Remove from cache to renderer it again
                renderCache.remove(wikittyId);
            }
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
    }
}
