/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.Map;
import java.util.Set;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import javax.swing.*;

/**
 * @author letellier
 */
public class FormTypeNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(FormTypeNavigationTreeHelper.class);

    public FormTypeNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.FORM_TYPE.getCategoryName(),
                null,
                new FormTypeNodeLoadors()
        );
    }

    @Override
    // FIXME SLE 21092010 : extension id change on save, so we can't select it after refresh 
    public void putExtension(WikittyServiceEvent event) {

        Set<String> extentionsId = event.getIds();
        Map<String, Set<String>> wikittiesExtensions = event.getIdExtensions();

        for (final String extentionId : extentionsId) {
            Set<String> wikittyExtensions = wikittiesExtensions.get(extentionId);
            if (wikittyExtensions.contains(Form.EXT_FORM)) {

                SwingUtilities.invokeLater(new Thread() {

                    @Override
                    public void run() {
                        // for putExtension, wikittyExtensions has only one element
                        VradiTreeNode existingNode = findNode(getRootNode(), extentionId);

                        // cas modification
                        if (existingNode != null) {
                            refresh(existingNode);
                        }

                        // cas creation
                        else {
                            createFormTypeNode(extentionId, false);
                        }
                    }
                });
            }
            else {
                log.debug("Can't manage event : " + extentionId + " ( " + wikittyExtensions + " )");
            }
        }
    }
}
