/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_THESAURUS_SELECTED = "thesaurusSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createNewRoot;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected javax.swing.JCheckBox expandByDefault;
    protected javax.swing.JToolBar headerPanel;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean selected;
    protected javax.swing.JButton sortButton;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected java.lang.Boolean thesaurusSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeTableHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
    //    setContextValue(new ModifThesaurusModel(this, helper));
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                    // Add mouse listener to enable menus
                    JMenuItem menuAddRootChild = new JMenuItem();
                    menuAddRootChild.setText(_("vradi.menu.addRootChildThesaurus"));
                    menuAddRootChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                             createNewRoot();
                        }
                    });
                    popup.add(menuAddRootChild);
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    if (isThesaurusSelected()) {
                        JMenuItem menuMoveSeleted = new JMenuItem();
                        menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                        menuMoveSeleted.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                moveSelected();
                            }
                        });
                        popup.add(menuMoveSeleted);
                    }
    
                    JMenuItem menuChangeColorSeleted = new JMenuItem();
                    menuChangeColorSeleted.setText(_("vradi.menu.menuChangeColorSeleted"));
                    menuChangeColorSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            changeColorSelected();
                        }
                    });
                    popup.add(menuChangeColorSeleted);
    
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)e.getPath().getLastPathComponent();
    
                boolean selectionEmpty = thesaurus.getTreeSelectionModel().isSelectionEmpty();
    
                // Set as selected
                setSelected(!selectionEmpty);
    
                // Is thesaurus
                if (selectedNode != null) {
                    setThesaurusSelected(isSelected() &&
                            Thesaurus.class.equals(selectedNode.getInternalClass()));
                }
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
    }
    
    protected void createNewRoot(){
        // Ajout dun nouveau root thesaurus
        getThesaurusHandler().createRootThesaurus(this);
    }
    
    protected void addChildToSelected(){
        // Ajout dun nouveau thesaurus
        getThesaurusHandler().addChildThesaurusToSelected(this, helper);
    }
    
    protected void editSelected(){
        // Edition dun thesaurus
        getThesaurusHandler().editThesaurusSelected(this, helper);
    }
    
    protected void deleteSelected(){
        // Suppression dun thesaurus
        getThesaurusHandler().deleteThesaurusSelected(this, helper);
    }
    
    protected void moveSelected(){
        // Move thesaurus
        getThesaurusHandler().moveThesaurusSelected(this, helper);
    }
    
    protected void changeColorSelected(){
        // Change color af selected detph
        getThesaurusHandler().changeThesaurusColor(this, helper);
    }
    
    protected void setExpandByDefault(){
        VradiHelper.storeOnClickThesaurusExpanded(expandByDefault.isSelected());
    }
    
    protected void sort() {
        thesaurus.setTreeTableModel(helper.createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getThesaurusHandler().importCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getThesaurusHandler().exportThesaurusCSV(this);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__createNewRoot(java.awt.event.ActionEvent event) {
        createNewRoot();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__expandByDefault(java.awt.event.ActionEvent event) {
        setExpandByDefault();
    }

    public void doActionPerformed__on__sortButton(java.awt.event.ActionEvent event) {
        sort();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateNewRoot() {
        return createNewRoot;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public javax.swing.JCheckBox getExpandByDefault() {
        return expandByDefault;
    }

    public javax.swing.JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JButton getSortButton() {
        return sortButton;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getThesaurusSelected() {
        return thesaurusSelected;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    public java.lang.Boolean isThesaurusSelected() {
        return thesaurusSelected !=null && thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    public void setThesaurusSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.thesaurusSelected;
        this.thesaurusSelected = newValue;
        firePropertyChange(PROPERTY_THESAURUS_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(createNewRoot);
        headerPanel.add(create);
        headerPanel.add(edit);
        headerPanel.add(delete);
        headerPanel.add(expandByDefault);
        headerPanel.add($JButton0);
        headerPanel.add($JButton1);
        headerPanel.add(sortButton);
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateNewRoot() {
        $objectMap.put("createNewRoot", createNewRoot = new javax.swing.JButton());
        
        createNewRoot.setName("createNewRoot");
        createNewRoot.setText(_("vradi.thesaurus.createNewRoot"));
        createNewRoot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewRoot"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createExpandByDefault() {
        $objectMap.put("expandByDefault", expandByDefault = new javax.swing.JCheckBox());
        
        expandByDefault.setName("expandByDefault");
        expandByDefault.setText(_("vradi.thesaurus.expendByDefault"));
        expandByDefault.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__expandByDefault"));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BoxLayout(headerPanel, BoxLayout.X_AXIS));
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new javax.swing.JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToHeaderPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        createNewRoot.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        expandByDefault.setSelected(VradiHelper.isOnClickThesaurusExpanded());
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("export"));
        sortButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("sort"));
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createThesaurusSelected();
        createHeaderPanel();
        createCreateNewRoot();
        createCreate();
        createEdit();
        createDelete();
        createExpandByDefault();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminThesaurus.importThesaurusCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminThesaurus.exportThesaurusCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSortButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}