/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.models.AdminTreeSelectionModel;
import com.jurismarches.vradi.ui.admin.renderers.AdminCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.datatips.DataTipManager;
import org.nuiton.wikitty.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminNavUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTER_TREE_MODEL = "filterTreeModel";
    public static final String PROPERTY_SHOW_IMPORT_EXPORT = "showImportExport";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_IMPORT_PANEL_VISIBLE = "importPanel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminNavUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminNavUI adminNavUI = this;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JTextField filterField;
    protected org.nuiton.widget.tree.FilterTreeModel filterTreeModel;
    protected javax.swing.JToolBar headerPanel;
    protected javax.swing.JToolBar importPanel;
    protected javax.swing.JTree nav;
    protected javax.swing.JPanel navPanel;
    protected javax.swing.JLabel none;
    protected java.lang.Boolean showImportExport;
    protected javax.swing.JButton sortButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String NONE = "none";
    
    
    // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
    //protected boolean contextInitialized = false;
    
    public  AdminNavUI(JAXXContext parentContext, AdminNavigationTreeHelper helper) {
        SwingUtil.initContext(this, parentContext);
        setContextValue(helper);
        // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
        //contextInitialized = true;
    $initialize();
    }
    
    public AdminContentUI getCurrentContent() {
        Component visibleComponent = contentLayout.getVisibleComponent(content);
        if (visibleComponent instanceof AdminContentUI) {
            return (AdminContentUI) visibleComponent;
        }
        return null;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    protected void $afterCompleteSetup() {
    
        SwingUtil.addExpandOnClickListener(nav);
    
        // extended tooltip for hidden content
        DataTipManager.get().register(nav);
    
        VradiDataProvider dataProvider = getHelper().getDataProvider();
    
        // Register decorator
        DecoratorProvider decoratorProvider = VradiContext.get().getDecoratorProvider();
    
        // Attach renderer
        nav.setCellRenderer(new AdminCellRenderer(decoratorProvider, dataProvider));
        nav.setSelectionModel(new AdminTreeSelectionModel(this, getHandler()));
    
        // Register tree
        getHelper().setUI(nav, true);
    
        // Single selection mode
        nav.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    }
    
    /**
     * Update tree filter on filter model and expand all tree.
     */
    protected void updateFilter() {
        String filterString = filterField.getText();
        AdminNavTreeFilter treeFilter = new AdminNavTreeFilter(filterString);
        filterTreeModel.setFilter(treeFilter);
    
        // si le filtre n'est pas vide, on etend completement l'arbre
        if (StringUtils.isNotEmpty(filterString)) {
    
            // expand the tree
            SwingUtil.expandTree(nav);
            //expandAll(nav, new TreePath(nav.getModel().getRoot()));
        }
    }
    
    /*
     * Expand all node in tree.
     *
    protected void expandAll(JTree tree, TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path);
            }
        }
        // Expansion or collapse must be done bottom-up
        tree.expandPath(parent);
    }*/
    
    /**
     * Reset filter (clear filter text).
     */
    public void resetFilter() {
        getFilterField().setText("");
    }
    
    protected void sort() {
        resetFilter();
        nav.setModel(getHelper().createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminNavUI() {
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().importClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().exportClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__sortButton(java.awt.event.ActionEvent event) {
        sort();
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JTextField getFilterField() {
        return filterField;
    }

    public org.nuiton.widget.tree.FilterTreeModel getFilterTreeModel() {
        return filterTreeModel;
    }

    public javax.swing.JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public javax.swing.JToolBar getImportPanel() {
        return importPanel;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JPanel getNavPanel() {
        return navPanel;
    }

    public javax.swing.JLabel getNone() {
        return none;
    }

    public java.lang.Boolean getShowImportExport() {
        return showImportExport;
    }

    public javax.swing.JButton getSortButton() {
        return sortButton;
    }

    public java.lang.Boolean isShowImportExport() {
        return showImportExport !=null && showImportExport;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void setFilterTreeModel(org.nuiton.widget.tree.FilterTreeModel newValue) {
        org.nuiton.widget.tree.FilterTreeModel oldValue = this.filterTreeModel;
        this.filterTreeModel = newValue;
        firePropertyChange(PROPERTY_FILTER_TREE_MODEL, oldValue, newValue);
    }

    public void setShowImportExport(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showImportExport;
        this.showImportExport = newValue;
        firePropertyChange(PROPERTY_SHOW_IMPORT_EXPORT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminNavUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(navPanel, JSplitPane.LEFT);
        add(content, JSplitPane.RIGHT);
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JPanel0, NONE);
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(filterField, BorderLayout.CENTER);
        headerPanel.add(sortButton, BorderLayout.EAST);
    }

    protected void addChildrenToImportPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importPanel.add($JButton0);
        importPanel.add($JButton1);
    }

    protected void addChildrenToNavPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navPanel.add($JScrollPane0, BorderLayout.CENTER);
        navPanel.add(importPanel, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new javax.swing.JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterTreeModel() {
        $objectMap.put("filterTreeModel", filterTreeModel = new org.nuiton.widget.tree.FilterTreeModel(getHelper().createTreeModel()));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createImportPanel() {
        $objectMap.put("importPanel", importPanel = new javax.swing.JToolBar());
        
        importPanel.setName("importPanel");
        importPanel.setFloatable(false);
        importPanel.setLayout(new GridLayout(1, 2));
        importPanel.setOpaque(false);
        importPanel.setBorderPainted(false);
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(false);
    }

    protected void createNavPanel() {
        $objectMap.put("navPanel", navPanel = new javax.swing.JPanel());
        
        navPanel.setName("navPanel");
        navPanel.setLayout(new BorderLayout());
    }

    protected void createNone() {
        $objectMap.put("none", none = new javax.swing.JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("vradi.admin.noSelection"));
    }

    protected void createShowImportExport() {
        $objectMap.put("showImportExport", showImportExport = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new javax.swing.JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminNavUI();
        addChildrenToNavPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        addChildrenToHeaderPanel();
        addChildrenToImportPanel();
        addChildrenToContent();
        // inline complete setup of $JPanel0
        $JPanel0.add(none, BorderLayout.CENTER);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setDividerLocation(200);
        setResizeWeight(0.1);
        $JScrollPane0.setColumnHeaderView(headerPanel);
        nav.setModel(filterTreeModel);
        sortButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("sort"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("export"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminNavUI", this);
        createContentLayout();
        createFilterTreeModel();
        createShowImportExport();
        createNavPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createHeaderPanel();
        createFilterField();
        createSortButton();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = filterField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createImportPanel();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.admin.importCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.admin.exportCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContent();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createNone();
        // inline creation of adminNavUI
        setName("adminNavUI");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        setDividerSize(12);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMPORT_PANEL_VISIBLE, true ,"showImportExport") {
        
            @Override
            public void processDataBinding() {
                importPanel.setVisible(isShowImportExport());
            }
        });
    }

}