package com.jurismarches.vradi.ui.tree;

import jaxx.runtime.swing.nav.treetable.NavTreeTableNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;

/**
 * Vradi node use to fill vradi tree table.
 * <p/>
 * User: sletellier
 */
public class VradiTreeTableNode extends NavTreeTableNode<VradiTreeTableNode> {

    private static final long serialVersionUID = 1L;

    public VradiTreeTableNode(String id) {
        super(id);
    }

    public VradiTreeTableNode(Class<?> internalClass,
                            String id,
                            String context,
                            NavTreeTableNodeChildLoador<?, ?, VradiTreeTableNode> loador) {
        super(internalClass, id, context, loador);
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public VradiTreeTableNode getContainerNode() {
        if (isRoot()) {
            // si on arrive sur le root, quelque chose ne va pas,
            // on bloque par null, a defaut de declancher une exception
            return this;
        }

        // cas final : sur un noeud de donnee + classe interne de donnee
        return super.getContainerNode();
    }
}