package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.wikitty.WikittyProxy;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SessionViewUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_FIELD_TEXT = "descriptionField.text";
    public static final String BINDING_RECEPTION_PROOF_FIELD_SELECTED = "receptionProofField.selected";
    public static final String BINDING_STATUS_FIELD_TEXT = "statusField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWQW8bRRTHJ6a24wSXUrdpStMqtJEqVXSdBAGChJLGNE0jl0ZxiCosoY53J/aE8c4yM9tsekB8BD4C3LkgceOEOHDmwAXxFRDiwBX1zay9603W9grnMM7Oe+83/3kz82a+/wvlpUBvHuEgsITvKtol1s79p0+ftI6IrT4m0hbUU1yg8G8qh3JNNOtE/VKhW826Dq/2wqs13vW4S9yB6LU6mpHqhBHZIUQpdD0ZYUtZbUTmtcDzRZ8aiUqjfvvP37lvnK+/yyEUeKBuHqayOC4qnsm5OspRR6GLMNJzXGXYbYMMQd026C3rvhrDUn6Cu+RL9BUq1lHBwwJgCt3MPmXDMPGBp1BZEikpdw8oOf70kUJ3bd61jnxBZRcLu0Ok9Vxgh1o+tUgXU2Y1Bv09z5AKCs3xw0Mi6lSqGmd+193CNgx6otC7w4EmxHqSGhiTKxF5H7cYecwdwhT6YBy2q/1kTI+DY/S5FsGuQreHsCB/VFH4bBDXgVWIA4u9rGWKNZ5xbHlpp2ELztgudsmyQlf0wgaWPIYRrAGTdi9FUdNLO7qTQcDFRIDp1U7zsbolM1lwnU9svjDC2LTntSggD1oZOU2u41ZIvnFGxYr+vp60zUrIUi9TsGoJ1KavFHeT/uWlbepwEZpA640UrQMe6UJWIyHxbIo2LAzkX38u6uat05lZiUzWINFMeFl/39LN8sDUFFa+3KKEOSnmiiA28RSs8q7g/NC4KXQ5kYFah9hfbPIgGdnTszpCz0o04PvpW8g4vJF0uNAviKApVc4+CdR9QbD2/zCduxpx4/yVWP8kKXQn08GOdtumB8XwWmKNocxacZmN6+BUE+WFD92wgZtnK/MemMKaPH+qJmugsf43V/n9pz9/3OoX4qsw9uVU14F7BAqkJ7hHhD63Cr0WVmFfUVZ9jL21JipJwogdXjILKcIaPTOIg/Fe1+GWDre2sewAIl/84+df5p799grKbaEZxrETFrtHqKQ6ArLAmRN4H20YRa8eT0N7QWtTqMDwCYdjgM6vO1jhxRY1x+xeAElYSElCpKRV+vXfSuOHjX4ipkDY1aHucTLyn6ECdRl1ibmTetdN6h0060niOzy+VtIumin9O+P1qmDdtLtnZ6q793TTCHz9s28k6/8OjG1hLAGKuoK9PYJxMwuD2mHFGcK4nYFRJK7e+85EGN39ORTm9XAxFrGC90DLV+TeBMI61CH71Bsh7E4WDOzX48kxBYVFm4xasCyUckg5oJL26s3/ho3bg3ezLZpuuumEt7MThmh4J0NKpsNqNXIDvjfxXCYnrE+cjY0M2TiPfcX3iKQvzCNwBO1BBtol27xVa/DQgOty/K7Lwizbg+/fCWGVQ8qY1I90jwu1TWi7M+qIZUGW2oI68EbnYkLQlQ4X9AWkDrPwtfFgbKHMgs2bF/+EkGld1B4KOk7MS+YVcL2oDgAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SessionViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Sending bean;
    protected jaxx.runtime.swing.Table content;
    protected javax.swing.JTextArea descriptionField;
    protected com.jurismarches.vradi.ui.offer.OfferTable listTable;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JCheckBox receptionProofField;
    protected javax.swing.JButton sendSending;
    protected com.jurismarches.vradi.entities.Session session;
    protected SessionViewUI sessionViewUI = this;
    protected javax.swing.JLabel statusField;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        jaxx.runtime.JAXXUtil.assignment(helper = getContextValue(EmailNavigationTreeHelper.class), "helper", com.jurismarches.vradi.ui.email.SessionViewUI.this);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        Sending sendingToDisplay = getContextValue(Sending.class);
        Session currentSession = getContextValue(Session.class);
        setSession(currentSession);
        setBean(sendingToDisplay);
        title.setText(updateTitle());
        sendSending.setEnabled(isSent());
    }
    
    public void updateDatas(){
        java.util.List<String> ids = new ArrayList<String>(getBean().getForm());
        java.util.List<Form> forms = VradiService.getWikittyProxy().restore(Form.class, ids);
        offerListTableModel.setFormPagedResult(new FormPagedResult(forms));
    }
    
    protected String updateTitle() {
        if (getBean() == null){
            return "";
        }
        String msg = "";
        WikittyProxy proxy = VradiService.getWikittyProxy();
        String userId = getBean().getUser();
        if (userId != null){
            User user = proxy.restore(User.class, userId);
            if (user != null) {
                msg = _("vradi.email.titleUser", user.getName());
            }
        }
        String groupId = getBean().getGroup();
        if (groupId != null){
            Group group = proxy.restore(Group.class, groupId);
            if (group != null) {
                msg = _("vradi.email.titleGroup", group.getName());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Title : " + msg);
        }
        return msg;
    }
    
    protected boolean isSent(){
        if (getBean() == null){
            return false;
        }
        return getBean().getStatus() == VradiConstants.SendingStatus.SENT.getValue() ||
               getBean().getStatus() == VradiConstants.SendingStatus.ERROR.getValue() ||
               getBean().getStatus() == VradiConstants.SendingStatus.WAITING_RECEPTION_PROOF.getValue();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionViewUI() {
        $initialize();
    }

    public SessionViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__receptionProofField(java.awt.event.ActionEvent event) {
        getHandler().updateReceptionProof(getSession(), getBean(),                                                         receptionProofField.isSelected());
    }

    public void doActionPerformed__on__sendSending(java.awt.event.ActionEvent event) {
        getHandler().sendSending(this, getBean());
    }

    public void doFocusLost__on__descriptionField(java.awt.event.FocusEvent event) {
        getHandler().updateParagraph(getSession(), getBean(),                                                          getBean().getParagraph());
    }

    public void doKeyReleased__on__descriptionField(java.awt.event.KeyEvent event) {
        getBean().setParagraph(descriptionField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Sending getBean() {
        return bean;
    }

    public jaxx.runtime.swing.Table getContent() {
        return content;
    }

    public javax.swing.JTextArea getDescriptionField() {
        return descriptionField;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JCheckBox getReceptionProofField() {
        return receptionProofField;
    }

    public javax.swing.JButton getSendSending() {
        return sendSending;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    public javax.swing.JLabel getStatusField() {
        return statusField;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Sending newValue) {
        com.jurismarches.vradi.entities.Sending oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($Table1, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        content.add($Table2, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSessionViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.Table());
        
        content.setName("content");
    }

    protected void createDescriptionField() {
        $objectMap.put("descriptionField", descriptionField = new javax.swing.JTextArea());
        
        descriptionField.setName("descriptionField");
        descriptionField.setColumns(15);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        descriptionField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__descriptionField"));
        descriptionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descriptionField"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createReceptionProofField() {
        $objectMap.put("receptionProofField", receptionProofField = new javax.swing.JCheckBox());
        
        receptionProofField.setName("receptionProofField");
        receptionProofField.setText(_("vradi.email.receptionProof"));
        receptionProofField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receptionProofField"));
    }

    protected void createSendSending() {
        $objectMap.put("sendSending", sendSending = new javax.swing.JButton());
        
        sendSending.setName("sendSending");
        sendSending.setText(_("vradi.email.sendSending"));
        sendSending.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSending"));
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createStatusField() {
        $objectMap.put("statusField", statusField = new javax.swing.JLabel());
        
        statusField.setName("statusField");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToSessionViewUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.NORTH);
        $JPanel0.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sendSending, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add(content, BorderLayout.NORTH);
        $JPanel2.add($JScrollPane2, BorderLayout.CENTER);
        addChildrenToContent();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(statusField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(receptionProofField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(descriptionField);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(listTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        title.setText(_(updateTitle()));
        sendSending.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        sendSending.setEnabled(isSent());
        $HidorButton0.setHideTip(_("vradi.email.hideForm"));
        $HidorButton0.setShowTip(_("vradi.email.showForm"));
        $HidorButton0.setTarget(content);
        $HidorButton0.setTargetVisible(true);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setFillsViewportHeight(true);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("sessionViewUI", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createBean();
        createSession();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSendSending();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.status"));
        createStatusField();
        createReceptionProofField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.paragraph"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDescriptionField();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_NEVER,                                                 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        
        $JScrollPane2.setName("$JScrollPane2");
        createListTable();
        // inline creation of sessionViewUI
        setName("sessionViewUI");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("status", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    statusField.setText(_(VradiConstants.SendingStatus.getStatus(getBean().getStatus()).getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("status", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEPTION_PROOF_FIELD_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("receptionProof", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    receptionProofField.setSelected(getBean().getReceptionProof());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("receptionProof", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(descriptionField, getBean().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}