package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.email.renderers.EmailCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EmailPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQW8bRRSeuE1SJzEJNklbNVQujYBDWRcQQigVLXUbGsu0UR0gwhfGu5N40vHMMjObbDggblz5CXCGCxI3TogDZw5cEH8BIQ5cK97M2rvZdL1e4Rw2ybz3vnnfe99++/1faFZJdO0Qh6EjA67pgDit9/b2HvUOiavvEeVK6mshUfQzU0KlLlr04nOl0fVu25Q3huWNphj4ghN+qnqzjRaUPmFE9QnRGr2YrnCVanTi8GboB3KEGjeVhfrNP3+Xvva+/LaEUOhDdzWgUp9UlTA530Yl6mlUhZuOcINhfgBtSMoPoN+KOWsyrNRDPCCfoS/QfBvN+VgCmEYvFadsMWx96Gu0RAaYsh3hB/6H2xrdcMXAOQwkVQMs3T5RzpHEHnUC6thE5/6pdN+3OHMaVVzBNVzXxicigHaupkirY6DgNLH0ovgbSeHSRqvjM6p3MCc3NVozJMNhQRIxyeW45sJGyxwyyK+m8u2pSVp+Jvd18/8L5lGNY/Mbu7jHzLWXMtq1MZO5ehqsjXsZF9tTk3Qxzn1eEaWo4PewJjvUfUKkRnUhD5xD0OoTLfyoNnRae0lKGmJ0ne19PR2r7FOmiWz2hVAGejXVD6y/J+6KMF1T3mjdheUIDv3XUvnRcZpsBTbjSsHYcDUX06uJQ+mZnuP4CMincnclsVmvJpMfyiVeyvLZpVjOl9N7j/u3wVfM42YiJEWMYBMmZ+KLinCvE+0kI1xxMXcJy0iQ6EpKHeANTuINycs700WzMoBjkFP3WTt5DKHISC6dMRIDaKNP12q///Tnj1sj97gKd69mpp4yP3irfSl80AA1Vy9H1hFoyhofYH+zi8qKMHBO64zrGY11hmFoDu6zm3NMufMAqz5AzM7/8fMva5/+dg6VttACE9jbwiZ/G5V1X8IUBPNC//Yd29HS8QV4rpjeQJMe2ccB000GGn0ELWINs9XouVse1rjeo9wDfbwbwkzWM2YSN9Yr//pvrfPDndFcZqDPy2PTk9nMfoLmKGeUE+urQ8vM9NFFX5HAE4k1ZpnljPm94A/N67Z9NrOIz/UJPeiDDVZvRffXsQYb7wWaAFtT9r6lYf7aLo7KrHma+Nb/R5nVVEe+9nAKkGP4TPWnBKkHoArOTj6iisIbn3yyYKN89BaOwa8UwK8C2q4I3P790MfcG9n5GMSVAohLIHf6OfnYbjdnD5OxzHEnB6E2NcJaAT7nNQl1zkyuFOriJAfhWhExDYQXfT3HULlehAp1I8GMwXi5AEZ5H9zpNbPhHEY3CgAtSiH0UNZTQq2Avx6rx4D3ADQMX5ep8CaJplEI4aschDenlkwxhLwe3iow13nCjSF4U8FMolIMIY/K24UQvpsaIY9FMYQ8Fu9MzaIYQh6LyQggiqOJ76yB+Q/K6XRmpA4AAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.EmailPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancelSession;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected EmailPopupUI emailPopupUI = this;
    protected javax.swing.JComboBox filterChooser;
    protected javax.swing.JTree nav;
    protected javax.swing.JButton searchButton;
    protected javax.swing.JButton sendSession;
    protected org.jdesktop.swingx.JXDatePicker sessionDatePicker;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    protected EmailNavigationTreeHelper getHelper() {
        return helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    
        final VradiDataProvider dataProvider = new VradiDataProvider();
    
        jaxx.runtime.JAXXUtil.assignment(helper = new EmailNavigationTreeHelper(dataProvider), "helper", com.jurismarches.vradi.ui.email.EmailPopupUI.this);
    
        // Creation of selection listener to open ui when tree selection change
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath path = event.getPath();
                VradiTreeNode node = (VradiTreeNode) path.getLastPathComponent();
    
                if (log.isDebugEnabled()) {
                    log.debug("Select node " + node);
                }
    
                // Do nothing for root
                if (node.isRoot()) {
                    return;
                }
                getHandler().openUI(EmailPopupUI.this, dataProvider, contentLayout, content, node);
                updateButtons();
            }
        };
                      
        // Register tree
        helper.setUI(nav, true, selectionListener);
    
        sessionDatePicker.setDate(new Date());
    
        updateTree();
        SwingUtil.addExpandOnClickListener(nav);
    
        // Attach renderer
        nav.setCellRenderer(new EmailCellRenderer(dataProvider));
    }
    
    public void updateTree() {
        if (log.isDebugEnabled()) {
            log.debug("updateTree");
        }
        java.util.List<Session> sessions = getHandler().getSessions(sessionDatePicker.getDate());
        helper.updateTree(sessions, (EmailNavigationTreeHelper.EmailFilterEnum)filterChooser.getSelectedItem());
        updateButtons();
    }
    
    protected void sendSession() {
        // disable buttons to avoid duplicate send
        boolean started = getHandler().send(this);
        updateButtons();
    }
    
    protected void updateButtons() {
        boolean isOpenSession = isOpenSession();
        sendSession.setEnabled(isOpenSession);
        cancelSession.setEnabled(isOpenSession);
        searchButton.setEnabled(isOpenSession);
    }
    
    protected boolean isOpenSession() {
        if (helper == null) {
            return false;
        }
        Session session = helper.getSelectedActiveSession();
    
        if (session == null) {
            return false;
        }
    
        return true;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailPopupUI() {
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        updateTree();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().createNewSession(this);
    }

    public void doActionPerformed__on__cancelSession(java.awt.event.ActionEvent event) {
        getHandler().cancelSession(this);
    }

    public void doActionPerformed__on__searchButton(java.awt.event.ActionEvent event) {
        getHandler().bindEmailsWithForms(this);
    }

    public void doActionPerformed__on__sendSession(java.awt.event.ActionEvent event) {
        sendSession();
    }

    public void doWindowClosing__on__emailPopupUI(java.awt.event.WindowEvent event) {
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancelSession() {
        return cancelSession;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JComboBox getFilterChooser() {
        return filterChooser;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JButton getSearchButton() {
        return searchButton;
    }

    public javax.swing.JButton getSendSession() {
        return sendSession;
    }

    public org.jdesktop.swingx.JXDatePicker getSessionDatePicker() {
        return sessionDatePicker;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEmailPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createCancelSession() {
        $objectMap.put("cancelSession", cancelSession = new javax.swing.JButton());
        
        cancelSession.setName("cancelSession");
        cancelSession.setText(_("vradi.email.cancelSession"));
        cancelSession.setVisible(true);
        cancelSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelSession"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterChooser() {
        $objectMap.put("filterChooser", filterChooser = new javax.swing.JComboBox());
        
        filterChooser.setName("filterChooser");
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(true);
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new javax.swing.JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(_("vradi.email.bindSession"));
        searchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__searchButton"));
    }

    protected void createSendSession() {
        $objectMap.put("sendSession", sendSession = new javax.swing.JButton());
        
        sendSession.setName("sendSession");
        sendSession.setText(_("vradi.email.sendSession"));
        sendSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSession"));
    }

    protected void createSessionDatePicker() {
        $objectMap.put("sessionDatePicker", sessionDatePicker = new org.jdesktop.swingx.JXDatePicker());
        
        sessionDatePicker.setName("sessionDatePicker");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEmailPopupUI();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(content, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add($Table0, BorderLayout.CENTER);
        $JPanel1.add($JButton0, BorderLayout.EAST);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sessionDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(filterChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        // inline complete setup of $Table1
        $Table1.add($JButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(searchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sendSession, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(cancelSession, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JSplitPane0.setResizeWeight(0.1);
        filterChooser.setModel(new DefaultComboBoxModel(EmailNavigationTreeHelper.EmailFilterEnum.values()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("new"));
        searchButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        searchButton.setEnabled(isOpenSession());
        sendSession.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        sendSession.setEnabled(isOpenSession());
        cancelSession.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        cancelSession.setEnabled(isOpenSession());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("emailPopupUI", this);
        createContentLayout();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.session"));
        createSessionDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.filter"));
        createFilterChooser();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.email.newSession"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSearchButton();
        createSendSession();
        createCancelSession();
        // inline creation of emailPopupUI
        setName("emailPopupUI");
        SwingUtil.setComponentHeight(emailPopupUI,600);
        emailPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.email.title"));
        SwingUtil.setComponentWidth(emailPopupUI,1024);
        emailPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__emailPopupUI"));
        
        $completeSetup();
    }

}