package com.jurismarches.vradi.ui.admin.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.RootThesaurusNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author letellier
 */
public class RootThesaurusTreeTableNodeLoadors extends NavTreeTableNodeChildLoador<String, RootThesaurus, VradiTreeTableNode> {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(RootThesaurusNodeLoadors.class);

    public RootThesaurusTreeTableNodeLoadors() {
        super(RootThesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) {

        List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.getAllRootThesaurus();

        if (log.isDebugEnabled()) {
            for (RootThesaurus root : rootThesaurusList) {
                log.debug("Root thesaurus find : " + root.getName());
            }
        }
        Collections.sort(rootThesaurusList, VradiComparators.ROOT_THESAURUS_COMPARATOR);

        // Return children
        return extractIds(rootThesaurusList);
    }

    @Override
    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeTableNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)
            );
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}