/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.*;

import com.jurismarches.vradi.ui.admin.loadors.GroupsNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class GroupNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);

    public GroupNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.GROUP.getCategoryName(),
                null,
                new GroupsNodeLoadors()
        );
    }

    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains(Group.EXT_GROUP)) {

                VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);
                // cas modification
                if (existingNode != null) {
                    // Modification case        
                    VradiTreeNode parentNode = existingNode.getParent();
                    UIHelper.refreshNodeLater(this, parentNode.getId());
                }

                // cas creation
                else {
                    VradiTreeNode parentNode = findNode(getRootNode(), AdminBeanConstant.GROUP.getCategoryName());

                    VradiTreeNode groupNode = getChildLoador(GroupsNodeLoadors.class).createNode(wikittyId, getDataProvider());

                    parentNode.add(groupNode);
                    UIHelper.refreshNodeLater(this, parentNode.getId());
                }
            }
        }
    }
}
