/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.Map;
import java.util.Set;

import com.jurismarches.vradi.ui.admin.loadors.ClientUsersNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class ClientNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.CLIENT.getCategoryName(),
                null,
                new ClientsAndUsersNodeLoadors()
        );
    }

    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putWikitty(final WikittyServiceEvent event) {

        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains(Client.EXT_CLIENT)) {

                VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);
                // cas modification
                if (existingNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Client modification occured");
                    }
                    // Reconstruction des fils
                    VradiTreeNode parentNode = existingNode.getParent();
                    UIHelper.refreshNodeLater(ClientNavigationTreeHelper.this, parentNode.getId());
                }

                // cas creation
                else {
                    if (log.isDebugEnabled()) {
                        log.debug("Client creation occured");
                    }
                    VradiTreeNode parentNode = findNode(getRootNode(), AdminBeanConstant.CLIENT.getCategoryName());
                    VradiTreeNode clientNode = getChildLoador(ClientsAndUsersNodeLoadors.class).createNode(wikittyId, getDataProvider());

                    UIHelper.refreshNodeLater(ClientNavigationTreeHelper.this, parentNode.getId());
                }
            }

            if (wikittyExtensions.contains(User.EXT_USER)) {
                VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);

                // cas modification
                if (existingNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("User modification occured");
                    }
                    // Reconstruction des fils
                    // FIXME SLE 07/09/2010 : Le noeud ne se recharge pas bien avec le parent
                    VradiTreeNode parentNode = getParentCategoryNode(existingNode, AdminBeanConstant.CLIENT.getCategoryName());
                    UIHelper.refreshNodeLater(ClientNavigationTreeHelper.this, parentNode.getId());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("User creation occured");
                    }
                    // cas creation
                    User data = VradiService.getWikittyProxy().restore(User.class, wikittyId);
                    String clientId = data.getClient();
                    VradiTreeNode clientNode = findNode(getRootNode(), clientId);
                    VradiTreeNode parentNode = findNode(clientNode, AdminBeanConstant.USER.getCategoryName());
                    VradiTreeNode userNode = getChildLoador(ClientUsersNodeLoadors.class).createNode(wikittyId, getDataProvider());

                    parentNode.add(userNode);
                    UIHelper.refreshNodeLater(ClientNavigationTreeHelper.this, parentNode.getId());
                }
            }
        }

    }
}
