package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ClientNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.FormTypeNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.GroupNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.admin.helpers.XmlStreamNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected com.jurismarches.vradi.ui.admin.content.AdminStatusUI adminStatus;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI adminThesaurus;
    protected com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI clientAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI formAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI groupAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI xmlStreamAdminNavUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    private VradiDataProvider dataProvider;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super();$initialize();
    
        SwingUtil.initContext(this, parentContext);
        jaxx.runtime.JAXXUtil.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminNavUI tab = getCurrentTab();
    
                    // null if is thesaurus selected
                    if (tab != null){
                        log.debug("current tab to close " + tab.getName());
                        AdminContentUI<?> content = tab.getCurrentContent();
                        boolean canContinue = getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.JAXXUtil.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        AdminNavUI navSelected = getCurrentTab();
        AdminHandler handler = getHandler();
        // if is thesaurus selected
        if (navSelected == null){
            handler.close(this);
            return;
        }
        AdminContentUI currentContent = navSelected.getCurrentContent();
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    public void updateTab(AdminNavUI ui) {
        // If id AdminThesaurus selected
        if (ui != null){
            TreePath path = ui.getNav().getSelectionPath();
            Object old = path == null ? null : path.getLastPathComponent();
    
            ui.getHelper().createTreeModel();
    
    //        if (old != null && old instanceof NavigationTreeNode) {
                // reselect node (if found)
    //            NavigationTreeNode node = (NavigationTreeNode) old;
    //            ui.getHelper().reSelectNode(ui, node.getFullPath());
    //        }
            ui.open();
        }
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doStateChanged__on__adminTabs(javax.swing.event.ChangeEvent event) {
        updateTab(getCurrentTab());
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.content.AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    public com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI getClientAdminNavUI() {
        return clientAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getFormAdminNavUI() {
        return formAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI getGroupAdminNavUI() {
        return groupAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getXmlStreamAdminNavUI() {
        return xmlStreamAdminNavUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add(clientAdminNavUI);
        adminTabs.add(groupAdminNavUI);
        adminTabs.add(formAdminNavUI);
        adminTabs.add(xmlStreamAdminNavUI);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new com.jurismarches.vradi.ui.admin.content.AdminStatusUI(this));
        
        adminStatus.setName("adminStatus");
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont((float) 20));
        }
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        
        adminTabs.setName("adminTabs");
        adminTabs.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__adminTabs"));
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI(this, new ThesaurusTreeTableHelper(dataProvider)));
        
        adminThesaurus.setName("adminThesaurus");
    }

    protected void createClientAdminNavUI() {
        $objectMap.put("clientAdminNavUI", clientAdminNavUI = new com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI(this, new ClientNavigationTreeHelper(dataProvider)));
        
        clientAdminNavUI.setName("clientAdminNavUI");
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setContinuousLayout(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setOneTouchExpandable(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setDividerSize(12);
    }

    protected void createFormAdminNavUI() {
        $objectMap.put("formAdminNavUI", formAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormTypeNavigationTreeHelper(dataProvider)));
        
        formAdminNavUI.setName("formAdminNavUI");
    }

    protected void createGroupAdminNavUI() {
        $objectMap.put("groupAdminNavUI", groupAdminNavUI = new com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI(this, new GroupNavigationTreeHelper(dataProvider)));
        
        groupAdminNavUI.setName("groupAdminNavUI");
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setContinuousLayout(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setOneTouchExpandable(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setDividerSize(12);
    }

    protected void createXmlStreamAdminNavUI() {
        $objectMap.put("xmlStreamAdminNavUI", xmlStreamAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(dataProvider)));
        
        xmlStreamAdminNavUI.setName("xmlStreamAdminNavUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(JLabel.LEFT);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminPopupUI", this);
        dataProvider = new VradiDataProvider();
        createAdminTabs();
        createClientAdminNavUI();
        createGroupAdminNavUI();
        createFormAdminNavUI();
        createXmlStreamAdminNavUI();
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        SwingUtil.setComponentHeight(adminPopupUI,600);
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.admin.title"));
        SwingUtil.setComponentWidth(adminPopupUI,1024);
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}