/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.slf4j.Logger;

public class SolrException
extends RuntimeException {
    public boolean logged = false;
    int code = 0;

    public SolrException(ErrorCode code, String msg) {
        super(msg);
        this.code = code.code;
    }

    public SolrException(ErrorCode code, String msg, boolean alreadyLogged) {
        super(msg);
        this.code = code.code;
        this.logged = alreadyLogged;
    }

    public SolrException(ErrorCode code, String msg, Throwable th, boolean alreadyLogged) {
        super(msg, th);
        this.code = code.code;
        this.logged = alreadyLogged;
    }

    public SolrException(ErrorCode code, String msg, Throwable th) {
        this(code, msg, th, true);
    }

    public SolrException(ErrorCode code, Throwable th) {
        super(th);
        this.code = code.code;
        this.logged = true;
    }

    @Deprecated
    public SolrException(int code, String msg) {
        super(msg);
        this.code = code;
    }

    @Deprecated
    public SolrException(int code, String msg, boolean alreadyLogged) {
        super(msg);
        this.code = code;
        this.logged = alreadyLogged;
    }

    @Deprecated
    public SolrException(int code, String msg, Throwable th, boolean alreadyLogged) {
        super(msg, th);
        this.code = code;
        this.logged = alreadyLogged;
    }

    @Deprecated
    public SolrException(int code, String msg, Throwable th) {
        this(code, msg, th, true);
    }

    @Deprecated
    public SolrException(int code, Throwable th) {
        super(th);
        this.code = code;
        this.logged = true;
    }

    public int code() {
        return this.code;
    }

    public void log(Logger log) {
        SolrException.log(log, this);
    }

    public static void log(Logger log, Throwable e) {
        log.error(SolrException.toStr(e));
        if (e instanceof SolrException) {
            ((SolrException)e).logged = true;
        }
    }

    public static void log(Logger log, String msg, Throwable e) {
        log.error(msg + ':' + SolrException.toStr(e));
        if (e instanceof SolrException) {
            ((SolrException)e).logged = true;
        }
    }

    public static void logOnce(Logger log, String msg, Throwable e) {
        if (e instanceof SolrException && ((SolrException)e).logged) {
            return;
        }
        if (msg != null) {
            SolrException.log(log, msg, e);
        } else {
            SolrException.log(log, e);
        }
    }

    public String toString() {
        return super.toString();
    }

    public static String toStr(Throwable e) {
        CharArrayWriter cw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(cw);
        e.printStackTrace(pw);
        pw.flush();
        return cw.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorCode {
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        SERVER_ERROR(500),
        SERVICE_UNAVAILABLE(503),
        UNKNOWN(0);

        final int code;

        private ErrorCode(int c) {
            this.code = c;
        }

        public static ErrorCode getErrorCode(int c) {
            for (ErrorCode err : ErrorCode.values()) {
                if (err.code != c) continue;
                return err;
            }
            return UNKNOWN;
        }
    }
}

