/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedFile {
    private static final Set<File> deleteList = new HashSet<File>();

    public static InputStream getLatestFile(String dirName, String fileName) throws FileNotFoundException {
        ArrayList<File> oldFiles = null;
        final String prefix = fileName + '.';
        File f = new File(dirName, fileName);
        FileInputStream is = null;
        for (int retry = 0; retry < 10 && is == null; ++retry) {
            try {
                if (!f.exists()) {
                    File dir = new File(dirName);
                    Object[] names = dir.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith(prefix);
                        }
                    });
                    Arrays.sort(names);
                    f = new File(dir, (String)names[names.length - 1]);
                    oldFiles = new ArrayList<File>();
                    for (int i = 0; i < names.length - 1; ++i) {
                        oldFiles.add(new File(dir, (String)names[i]));
                    }
                }
                is = new FileInputStream(f);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            is = new FileInputStream(f);
        }
        if (oldFiles != null) {
            VersionedFile.delete(oldFiles);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void delete(Collection<File> files) {
        Set<File> set = deleteList;
        synchronized (set) {
            deleteList.addAll(files);
            ArrayList<File> deleted = new ArrayList<File>();
            for (File df : deleteList) {
                try {
                    df.delete();
                    deleted.add(df);
                }
                catch (SecurityException e) {
                    if (df.exists()) continue;
                    deleted.add(df);
                }
            }
            deleteList.removeAll(deleted);
        }
    }
}

