/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public class DoubleMetaphoneFilter
extends TokenFilter {
    private static final String TOKEN_TYPE = "DoubleMetaphone";
    private final LinkedList<AttributeSource.State> remainingTokens = new LinkedList();
    private final DoubleMetaphone encoder = new DoubleMetaphone();
    private final boolean inject;
    private final TermAttribute termAtt;
    private final PositionIncrementAttribute posAtt;

    protected DoubleMetaphoneFilter(TokenStream input, int maxCodeLength, boolean inject) {
        super(input);
        this.encoder.setMaxCodeLen(maxCodeLength);
        this.inject = inject;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        while (true) {
            if (!this.remainingTokens.isEmpty()) {
                this.restoreState(this.remainingTokens.removeFirst());
                return true;
            }
            if (!this.input.incrementToken()) {
                return false;
            }
            int len = this.termAtt.termLength();
            if (len == 0) {
                return true;
            }
            int firstAlternativeIncrement = this.inject ? 0 : this.posAtt.getPositionIncrement();
            String v = new String(this.termAtt.termBuffer(), 0, len);
            String primaryPhoneticValue = this.encoder.doubleMetaphone(v);
            String alternatePhoneticValue = this.encoder.doubleMetaphone(v, true);
            boolean saveState = this.inject;
            if (primaryPhoneticValue != null && primaryPhoneticValue.length() > 0 && !primaryPhoneticValue.equals(v)) {
                if (saveState) {
                    this.remainingTokens.addLast(this.captureState());
                }
                this.posAtt.setPositionIncrement(firstAlternativeIncrement);
                firstAlternativeIncrement = 0;
                this.termAtt.setTermBuffer(primaryPhoneticValue);
                saveState = true;
            }
            if (alternatePhoneticValue != null && alternatePhoneticValue.length() > 0 && !alternatePhoneticValue.equals(primaryPhoneticValue) && !primaryPhoneticValue.equals(v)) {
                if (saveState) {
                    this.remainingTokens.addLast(this.captureState());
                    saveState = false;
                }
                this.posAtt.setPositionIncrement(firstAlternativeIncrement);
                this.termAtt.setTermBuffer(alternatePhoneticValue);
                saveState = true;
            }
            if (this.remainingTokens.isEmpty()) {
                return true;
            }
            if (!saveState) continue;
            this.remainingTokens.addLast(this.captureState());
        }
    }

    public void reset() throws IOException {
        this.input.reset();
        this.remainingTokens.clear();
    }
}

