/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: SingletonOOo.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-services/src/main/java/com/jurismarches/vradi/services/ooo/SingletonOOo.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.ooo;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Yolpo, kmorin
 * 
 * Source : http://user.services.openoffice.org/fr/forum/viewtopic.php?f=15&t=17839
 */
public class SingletonOOo {

    private static Log log = LogFactory.getLog(SingletonOOo.class);

    private XComponentContext xContext = null;
    private static SingletonOOo oOo = null;
    private XMultiComponentFactory serviceManager = null;
    private Object desktop = null;
    private XComponentLoader loader = null;
    private static XBridge bridge;
    private Object mxMSF;
    public static final String DEFAULT_CONNECTION_STRING
            = "socket,host=localhost,port=8100";


    private SingletonOOo(String oOoExecFolder)
            throws com.sun.star.uno.Exception, BootstrapException {
        openConnectionOpenOffice(oOoExecFolder);
    }

    public static synchronized SingletonOOo GetInstance(String oOoExecFolder)
            throws com.sun.star.uno.Exception, BootstrapException {

        if (oOo == null || bridge == null) {
            oOo = new SingletonOOo(oOoExecFolder);
        }
        return oOo;
    }

    public XMultiComponentFactory getServiceManager() {

        return serviceManager;
    }

    public XComponentContext getXContext() {

        return xContext;
    }

    public XComponentLoader getLoader() {

        return loader;
    }

    public void openConnectionOpenOffice(String oOoExecFolder)
            throws BootstrapException, com.sun.star.uno.Exception {
        xContext = BootstrapSocketConnector.bootstrap(oOoExecFolder);

        // Création de l'objet de type Connector permettant de créer une
        // connection entre java et OOo
        Object x = xContext.getServiceManager().createInstanceWithContext(
                "com.sun.star.connection.Connector", xContext);
        XConnector xConnector = (XConnector) UnoRuntime
                .queryInterface(XConnector.class, x);

        // Création de la connection entre java et OOo
        XConnection connection = xConnector
                .connect(DEFAULT_CONNECTION_STRING);

        // Création du bridge, étape très importante pour pouvoir
        // fermer OOo sans avoir à faire un system.exit();
        // Le bridge est créé suivant la connection connection et le
        // protocol de discussion urp
        x = xContext.getServiceManager().createInstanceWithContext(
                "com.sun.star.bridge.BridgeFactory", xContext);

        XBridgeFactory xBridgeFactory = (XBridgeFactory) UnoRuntime
                .queryInterface(XBridgeFactory.class, x);

        if (xBridgeFactory != null) {

            bridge = xBridgeFactory.createBridge("", "urp", connection, null);

            // Création de la XMultiComponentFactory qui permettra d'avoir
            // acces aux services tels que le mailmerge
            XComponent xComponent = (XComponent) UnoRuntime
                    .queryInterface(XComponent.class, bridge);
            if (bridge != null) {
                x = bridge.getInstance("StarOffice.ServiceManager");
                serviceManager = (XMultiComponentFactory) UnoRuntime
                        .queryInterface(XMultiComponentFactory.class, x);

                XPropertySet xProperySet = (XPropertySet) UnoRuntime
                        .queryInterface(XPropertySet.class, serviceManager);

                Object oDefaultContext = xProperySet
                        .getPropertyValue("DefaultContext");

                xContext = (XComponentContext) UnoRuntime
                        .queryInterface(XComponentContext.class, oDefaultContext);

                serviceManager = xContext.getServiceManager();

                desktop = serviceManager.createInstanceWithContext(
                        "com.sun.star.frame.Desktop", xContext);

                loader = (XComponentLoader) UnoRuntime
                        .queryInterface(XComponentLoader.class, desktop);

                if (mxMSF == null) {
                    mxMSF = UnoRuntime
                            .queryInterface(XMultiServiceFactory.class,
                                    serviceManager);
                }
            }
            else {
                if (log.isWarnEnabled()) {
                    log.warn("Can't bridge to ooo server");
                }
            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Can't init bridge factory");
            }
        }
    }

    public void closeConnectionOpenOffice() {
        XComponent xcomponent = (XComponent) UnoRuntime
                .queryInterface(XComponent.class, bridge);
        xcomponent.dispose();
    }

}
