/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.bundle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleScope;

public class I18nBundle
implements Iterable<I18nBundleEntry> {
    static final Log log = LogFactory.getLog(I18nBundle.class);
    protected List<I18nBundleEntry> entries;
    final String bundlePrefix;

    public I18nBundle(String bundlePrefix) {
        this.bundlePrefix = bundlePrefix;
    }

    public String getBundlePrefix() {
        return this.bundlePrefix;
    }

    public I18nBundleEntry[] getEntries(Locale locale) {
        I18nBundleScope scope = I18nBundleScope.valueOf(locale);
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        for (I18nBundleEntry entry : this.entries) {
            I18nBundleScope i18nBundleScope = entry.getScope();
            if (i18nBundleScope != scope && i18nBundleScope.ordinal() >= scope.ordinal() || !entry.matchLocale(locale, scope)) continue;
            result.add(entry);
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    public I18nBundleEntry[] getEntries(I18nBundleScope scope) {
        ArrayList<I18nBundleEntry> result = new ArrayList<I18nBundleEntry>();
        for (I18nBundleEntry entry : this.entries) {
            I18nBundleScope i18nBundleScope = entry.getScope();
            if (i18nBundleScope != scope) continue;
            result.add(entry);
        }
        return result.toArray(new I18nBundleEntry[result.size()]);
    }

    public int size() {
        return this.entries == null ? 0 : this.entries.size();
    }

    public String toString() {
        String s = super.toString();
        return "<" + s.substring(s.lastIndexOf(".") + 1) + ", bundlePrefix:" + this.bundlePrefix + ", size:" + this.size() + ">";
    }

    protected List<I18nBundleEntry> getEntries() {
        return this.entries;
    }

    protected boolean matchLocale(Locale locale) {
        I18nBundleScope scope = I18nBundleScope.valueOf(locale);
        boolean result = false;
        if (this.size() != 0) {
            for (I18nBundleEntry entry : this.entries) {
                if (!entry.matchLocale(locale, scope)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean addEntry(I18nBundleEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<I18nBundleEntry>();
        }
        boolean b = this.entries.add(entry);
        if (log.isInfoEnabled()) {
            log.info((Object)(this + "\n\t" + entry));
        }
        return b;
    }

    @Override
    public Iterator<I18nBundleEntry> iterator() {
        return this.entries.iterator();
    }
}

