/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryRequestWriter
extends RequestWriter {
    @Override
    public Collection<ContentStream> getContentStreams(SolrRequest req) throws IOException {
        if (req instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isNull(updateRequest.getDocuments()) && this.isNull(updateRequest.getDeleteById()) && this.isNull(updateRequest.getDeleteQuery()) && updateRequest.getDocIterator() == null) {
                return null;
            }
            ArrayList<ContentStream> l = new ArrayList<ContentStream>();
            l.add(new RequestWriter.LazyContentStream(this, updateRequest));
            return l;
        }
        return super.getContentStreams(req);
    }

    @Override
    public String getUpdateContentType() {
        return "application/octet-stream";
    }

    @Override
    public ContentStream getContentStream(UpdateRequest request) throws IOException {
        final BAOS baos = new BAOS();
        new JavaBinUpdateRequestCodec().marshal(request, baos);
        return new ContentStream(){

            public String getName() {
                return null;
            }

            public String getSourceInfo() {
                return "javabin";
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public Long getSize() {
                return new Long(baos.size());
            }

            public InputStream getStream() throws IOException {
                return new ByteArrayInputStream(baos.getbuf(), 0, baos.size());
            }

            public Reader getReader() throws IOException {
                throw new RuntimeException("No reader available . this is a binarystream");
            }
        };
    }

    @Override
    public void write(SolrRequest request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            new JavaBinUpdateRequestCodec().marshal(updateRequest, os);
        }
    }

    @Override
    public String getPath(SolrRequest req) {
        if (req instanceof UpdateRequest) {
            return "/update/javabin";
        }
        return req.getPath();
    }

    class BAOS
    extends ByteArrayOutputStream {
        BAOS() {
        }

        byte[] getbuf() {
            return this.buf;
        }
    }
}

