/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.IOException;
import org.htmlcleaner.BrowserCompactXmlSerializer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CompactXmlSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.webharvest.definition.HtmlToXmlDef;
import org.webharvest.exception.ParserException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class HtmlToXmlProcessor
extends BaseProcessor {
    private HtmlToXmlDef htmlToXmlDef;

    public HtmlToXmlProcessor(HtmlToXmlDef htmlToXmlDef) {
        super(htmlToXmlDef);
        this.htmlToXmlDef = htmlToXmlDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        String booleanAtts;
        String pruneTags;
        String namespacesAware;
        String allowHtmlInsideAttributes;
        String allowMultiWordAttributes;
        String omitHtmlEnvelope;
        String omitComments;
        String omitXmlDecl;
        String treatDeprTagsAsContent;
        String omitDeprecatedTags;
        String treatUnknownTagsAsContent;
        String useEmptyElementTags;
        String omitUnknownTags;
        String recognizeUnicodeChars;
        String specialEntities;
        String cdataForScriptAndStyle;
        Variable body = this.getBodyTextContent(this.htmlToXmlDef, scraper, context);
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties properties = cleaner.getProperties();
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String advancedXmlEscape = BaseTemplater.execute(this.htmlToXmlDef.getAdvancedXmlEscape(), scriptEngine);
        if (advancedXmlEscape != null) {
            properties.setAdvancedXmlEscape(CommonUtil.isBooleanTrue(advancedXmlEscape));
        }
        if ((cdataForScriptAndStyle = BaseTemplater.execute(this.htmlToXmlDef.getUseCdataForScriptAndStyle(), scriptEngine)) != null) {
            properties.setUseCdataForScriptAndStyle(CommonUtil.isBooleanTrue(cdataForScriptAndStyle));
        }
        if ((specialEntities = BaseTemplater.execute(this.htmlToXmlDef.getTranslateSpecialEntities(), scriptEngine)) != null) {
            properties.setTranslateSpecialEntities(CommonUtil.isBooleanTrue(specialEntities));
        }
        if ((recognizeUnicodeChars = BaseTemplater.execute(this.htmlToXmlDef.getRecognizeUnicodeChars(), scriptEngine)) != null) {
            properties.setRecognizeUnicodeChars(CommonUtil.isBooleanTrue(recognizeUnicodeChars));
        }
        if ((omitUnknownTags = BaseTemplater.execute(this.htmlToXmlDef.getOmitUnknownTags(), scriptEngine)) != null) {
            properties.setOmitUnknownTags(CommonUtil.isBooleanTrue(omitUnknownTags));
        }
        if ((useEmptyElementTags = BaseTemplater.execute(this.htmlToXmlDef.getUseEmptyElementTags(), scriptEngine)) != null) {
            properties.setUseEmptyElementTags(CommonUtil.isBooleanTrue(useEmptyElementTags));
        }
        if ((treatUnknownTagsAsContent = BaseTemplater.execute(this.htmlToXmlDef.getTreatUnknownTagsAsContent(), scriptEngine)) != null) {
            properties.setTreatUnknownTagsAsContent(CommonUtil.isBooleanTrue(treatUnknownTagsAsContent));
        }
        if ((omitDeprecatedTags = BaseTemplater.execute(this.htmlToXmlDef.getOmitDeprecatedTags(), scriptEngine)) != null) {
            properties.setOmitDeprecatedTags(CommonUtil.isBooleanTrue(omitDeprecatedTags));
        }
        if ((treatDeprTagsAsContent = BaseTemplater.execute(this.htmlToXmlDef.getTreatDeprecatedTagsAsContent(), scriptEngine)) != null) {
            properties.setTreatDeprecatedTagsAsContent(CommonUtil.isBooleanTrue(treatDeprTagsAsContent));
        }
        if ((omitXmlDecl = BaseTemplater.execute(this.htmlToXmlDef.getOmitXmlDecl(), scriptEngine)) != null) {
            properties.setOmitXmlDeclaration(CommonUtil.isBooleanTrue(omitXmlDecl));
        }
        if ((omitComments = BaseTemplater.execute(this.htmlToXmlDef.getOmitComments(), scriptEngine)) != null) {
            properties.setOmitComments(CommonUtil.isBooleanTrue(omitComments));
        }
        if ((omitHtmlEnvelope = BaseTemplater.execute(this.htmlToXmlDef.getOmitHtmlEnvelope(), scriptEngine)) != null) {
            properties.setOmitHtmlEnvelope(CommonUtil.isBooleanTrue(omitHtmlEnvelope));
        }
        if ((allowMultiWordAttributes = BaseTemplater.execute(this.htmlToXmlDef.getAllowMultiWordAttributes(), scriptEngine)) != null) {
            properties.setAllowMultiWordAttributes(CommonUtil.isBooleanTrue(allowMultiWordAttributes));
        }
        if ((allowHtmlInsideAttributes = BaseTemplater.execute(this.htmlToXmlDef.getAllowHtmlInsideAttributes(), scriptEngine)) != null) {
            properties.setAllowHtmlInsideAttributes(CommonUtil.isBooleanTrue(allowHtmlInsideAttributes));
        }
        if ((namespacesAware = BaseTemplater.execute(this.htmlToXmlDef.getNamespacesAware(), scriptEngine)) != null) {
            properties.setNamespacesAware(CommonUtil.isBooleanTrue(namespacesAware));
        } else {
            properties.setNamespacesAware(false);
        }
        String hyphenReplacement = BaseTemplater.execute(this.htmlToXmlDef.getHyphenReplacement(), scriptEngine);
        if (hyphenReplacement != null) {
            properties.setHyphenReplacementInComment(hyphenReplacement);
        }
        if ((pruneTags = BaseTemplater.execute(this.htmlToXmlDef.getPrunetags(), scriptEngine)) != null) {
            properties.setPruneTags(pruneTags);
        }
        if ((booleanAtts = BaseTemplater.execute(this.htmlToXmlDef.getBooleanAtts(), scriptEngine)) != null) {
            properties.setBooleanAttributeValues(booleanAtts);
        }
        String outputType = BaseTemplater.execute(this.htmlToXmlDef.getOutputType(), scriptEngine);
        try {
            TagNode node = cleaner.clean(body.toString());
            String result = "simple".equalsIgnoreCase(outputType) ? new SimpleXmlSerializer(properties).getXmlAsString(node) : ("pretty".equalsIgnoreCase(outputType) ? new PrettyXmlSerializer(properties).getXmlAsString(node) : ("browser-compact".equalsIgnoreCase(outputType) ? new BrowserCompactXmlSerializer(properties).getXmlAsString(node) : new CompactXmlSerializer(properties).getXmlAsString(node)));
            return new NodeVariable(result);
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
    }
}

