/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.ModificationTagImpl;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.MailingManager;
import com.sun.star.comp.helper.BootstrapException;
import java.io.File;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Search;

public class VradiStorageServiceTest
extends VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiStorageServiceTest.class);

    @Test
    public void testXmlStreamDuplication() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
        XmlStream xmlStream = this.createXmlStream(extension, bindings);
        XmlStreamImportResult result = this.storageService.importFormsFromXmlStream(xmlStream);
        Assert.assertEquals((long)5L, (long)result.getCreatedFormCount());
        Assert.assertEquals((long)0L, (long)result.getAlreadyExistsFormCount());
        this.testSearch("*", 5);
        result = this.storageService.importFormsFromXmlStream(xmlStream);
        Assert.assertEquals((long)0L, (long)result.getCreatedFormCount());
        Assert.assertEquals((long)5L, (long)result.getAlreadyExistsFormCount());
        this.testSearch("*", 5);
    }

    @Test
    public void testDateInterval() throws Exception {
        WikittyExtension extension = this.createFileFormType();
        XmlStreamImportResult initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData.getCreatedFormCount());
        FormPagedResult formPageDTO = new FormPagedResult();
        Date end = new Date();
        GregorianCalendar begin = new GregorianCalendar();
        begin.setTime(end);
        begin.set(12, begin.get(12) - 1);
        QueryParameters queryParameters = new QueryParameters();
        queryParameters.setDateFieldName("Infogene.creationDate");
        queryParameters.setBeginDate(begin.getTime());
        queryParameters.setEndDate(end);
        formPageDTO = this.dataService.findForms(queryParameters, formPageDTO);
        int total = formPageDTO.getTotalFoundFormNb();
        Assert.assertEquals((long)4L, (long)total);
        queryParameters.setEndDate(begin.getTime());
        formPageDTO = this.dataService.findForms(queryParameters, formPageDTO);
        total = formPageDTO.getTotalFoundFormNb();
        Assert.assertEquals((long)0L, (long)total);
    }

    @Test
    public void testFindFormWithPartialQuery() throws Exception {
        FormImpl form = new FormImpl();
        form.setObjet("Entretien des propri\u00e9t\u00e9s de sil\u00e8ne \u00e0 Saint Nazaire");
        this.wikittyProxy.store((BusinessEntity)form);
        FormPagedResult pagedResult = this.testSearch("objet:silene");
        Assert.assertEquals((long)1L, (long)pagedResult.getTotalFoundFormNb());
        pagedResult = this.testSearch("Entretien des propri\u00e9t\u00e9s de sil\u00e8ne \u00e0 Saint Nazaire");
        Assert.assertEquals((long)1L, (long)pagedResult.getTotalFoundFormNb());
        pagedResult = this.testSearch("objet:\"Entretien des propri\u00e9t\u00e9s de sil\u00e8ne \u00e0 Saint Nazaire\"");
        Assert.assertEquals((long)1L, (long)pagedResult.getTotalFoundFormNb());
        pagedResult = this.testSearch("objet:\"sil\u00e8ne \u00e0 Saint Nazaire\"");
        Assert.assertEquals((long)1L, (long)pagedResult.getTotalFoundFormNb());
    }

    @Test
    public void testSearchFile() throws Exception {
        WikittyExtension extension = this.createFileFormType();
        XmlStreamImportResult initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData.getCreatedFormCount());
        this.testSearch((String)null, 4);
        this.testSearch("", 4);
        this.testSearch("*", 4);
        this.testSearch("soir\u00e9e", 1);
        this.testSearch("soiree", 1);
        this.testSearch("description:soir\u00e9e", 1);
        this.testSearch("description:soiree", 1);
        this.testSearch("dir:(tmp)", 4);
        this.testSearch("dir:(/tmp)", 4);
        this.testSearch("dir:(NOT /tmp)", 0);
        this.testSearch("NOT dir:(/tmp)", 0);
        this.testSearch("name:(tr.txt)", 1);
        this.testSearch("name:(enscript.txt)", 1);
        this.testSearch("name:(wifi.txt)", 1);
        this.testSearch("name:(tr.txt OR enscript.txt)", 2);
        this.testSearch("name:(tr.txt AND enscript.txt)", 0);
        this.testSearch("name:(tr.txt OR enscript.txt OR wifi.txt)", 3);
        this.testSearch("name:(tr.txt OR enscript.txt) OR name:(wifi.txt)", 3);
        this.testSearch("name:(tr.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt AND enscript.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt OR enscript.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt OR enscript.txt) AND dir:(/tmp)", 2);
        this.testSearch("name:[e TO u]", 2);
        this.testSearch("name:[e TO v]", 3);
        this.testSearch("name:[e TO w]", 3);
        this.testSearch("name:[e TO x]", 4);
        this.testSearch("size:(203)", 1);
        this.testSearch("size:203", 1);
        this.testSearch("size:203 OR size:814", 2);
        this.testSearch("size:203 AND size:814", 0);
        this.testSearch("size:(203 OR 814) AND NOT size:125", 2);
        this.testSearch("size:(814)", 1);
        this.testSearch("size:(125)", 1);
        this.testSearch("size:(490)", 1);
        this.testSearch("size:(203 OR 814 OR 125 OR 490)", 4);
        this.testSearch("size:(203 OR 814) AND NOT size:(490)", 2);
        this.testSearch("size:(203) OR name:(tr.txt)", 1);
        this.testSearch("size:(203 OR 814 OR 125 OR 490) AND name:(tr.txt OR enscript.txt)", 2);
        this.testSearch("size:(203 OR 814 OR 125 OR 490) OR name:(tr.txt OR enscript.txt)", 4);
        this.testSearch("size:[125 TO 900]", 4);
        this.testSearch("size:[100 TO 300]", 2);
        this.testSearch("modified:(2009-11-29)", 1);
        this.testSearch("modified:(2008-12-21)", 1);
        this.testSearch("modified:(2009-09-28)", 1);
        this.testSearch("modified:(2009-09-06)", 1);
        this.testSearch("modified:[2008 TO 2009]", 1);
        this.testSearch("modified:[2008 TO 2009-10]", 3);
        this.testSearch("lastModified:06/09/2009", 1);
        this.testSearch("lastModified:\"06/09/2009\"", 1);
        this.testSearch("lastModified:28/09/2009", 1);
        this.testSearch("lastModified:\"28/09/2009\"", 1);
        this.testSearch("lastModified:[20090906 TO 20090928]", 2);
        this.testSearch("lastModified:[20090906 TO 20090920]", 1);
        FormPagedResult testSearch = this.testSearch("size:203");
        String formId = (String)testSearch.getFormsIdsToShow().get(0);
        Form form = (Form)this.wikittyProxy.restore(Form.class, formId);
        this.testSearch("id:" + form.getId(), 1);
        this.testSearch("id:" + form.getWikittyId(), 1);
    }

    @Test
    public void testSearchAnnonce() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        XmlStreamImportResult initData = this.initData(extension);
        Assert.assertEquals((long)5L, (long)initData.getCreatedFormCount());
        this.testSearch((String)null, 5);
        this.testSearch("", 5);
        this.testSearch("*", 5);
        this.testSearch("Localit\u00e9", 2);
        this.testSearch("Localite", 2);
        this.testSearch("acheteur:(Infocom94)", 1);
        this.testSearch("acheteur:(Infocom)", 1);
        this.testSearch("acheteur:(Ville de Nogent sur Marne)", 1);
        this.testSearch("acheteur:(Ville de Saint Joseph)", 1);
        this.testSearch("acheteur:(\"Ville de Saint Joseph\")", 1);
        this.testSearch("acheteur:(Ville)", 2);
        this.testSearch("acheteur:(Ville de)", 2);
        this.testSearch("acheteur:(Marne)", 1);
        this.testSearch("acheteur:(Joseph)", 1);
        this.testSearch("acheteur:(EMOC)", 2);
        this.testSearch("acheteur:(*OC)", 2);
        this.testSearch("acheteur:EM*", 2);
        this.testSearch("acheteur:(EM*)", 2);
        this.testSearch("acheteur:(E*OC)", 2);
        this.testSearch("acheteur:(E?OC)", 2);
        this.testSearch("acheteur:(EM?C)", 2);
        this.testSearch("acheteur:(EMO?)", 2);
        this.testSearch("acheteur:(EM??C)", 0);
        this.testSearch("departement:(972)", 1);
        this.testSearch("departement:(2)", 0);
        this.testSearch("departement:(*2)", 1);
        this.testSearch("departement:(94)", 2);
        this.testSearch("departement:(9)", 0);
        this.testSearch("departement:9*", 3);
        this.testSearch("departement:(9*)", 3);
        this.testSearch("departement:(N.D.)", 2);
        this.testSearch("date:(N.D.)", 2);
        this.testSearch("date:(N.)", 2);
        this.testSearch("date:(25/01/2010)", 1);
        this.testSearch("date:(19/01/2010)", 1);
        this.testSearch("date:(\"25/01/2010\"*)", 1);
        this.testSearch("date:(\"19/01/2010\"*)", 1);
        this.testSearch("date:(\"25/01/2010 17:00\")", 1);
        this.testSearch("date:(\"19/01/2010 - 11:00\")", 1);
    }

    @Test
    public void testDateFormats() throws Exception {
        WikittyExtension extension = this.createDatesFormType();
        XmlStreamImportResult initData = this.initData(extension);
        Assert.assertEquals((long)30L, (long)initData.getCreatedFormCount());
        Assert.assertEquals((long)5L, (long)initData.getDateParsingError());
    }

    @Test
    public void testSearchStatus() throws Exception {
        this.testSearch((Status[])null, 0);
        Status testStatus1 = this.createSatus("test1", null, 0, false);
        Status testStatus2 = this.createSatus("test2", null, 0, false);
        FormImpl fWithStatus1 = new FormImpl();
        fWithStatus1.setObjet("form with status1");
        fWithStatus1.setStatus(testStatus1.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)fWithStatus1);
        FormImpl fWithStatus2 = new FormImpl();
        fWithStatus2.setObjet("form with status2");
        fWithStatus2.setStatus(testStatus2.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)fWithStatus2);
        FormImpl fWithoutStatus = new FormImpl();
        fWithoutStatus.setObjet("form without status");
        this.wikittyProxy.store((BusinessEntity)fWithoutStatus);
        this.testSearch((Status[])null, 3);
        this.testSearch(new Status[0], 3);
        this.testSearch(new Status[]{testStatus1}, 1);
        this.testSearch(new Status[]{testStatus2}, 1);
        this.testSearch(new Status[]{testStatus1, testStatus2}, 2);
    }

    @Test
    public void testSearchThesaurus() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        this.testSearch("", 5);
        RootThesaurusImpl rootThesaurus = new RootThesaurusImpl();
        rootThesaurus.setName("thesaurus");
        this.wikittyProxy.store((BusinessEntity)rootThesaurus);
        Thesaurus abc = this.createThesaurus("ab c", null, (RootThesaurus)rootThesaurus, "ab c");
        Thesaurus def = this.createThesaurus("de f", abc.getWikittyId(), (RootThesaurus)rootThesaurus, "de f");
        Thesaurus ghi = this.createThesaurus("gh & i", abc.getWikittyId(), (RootThesaurus)rootThesaurus, "gh & i");
        Thesaurus jkl = this.createThesaurus("jk l", abc.getWikittyId(), (RootThesaurus)rootThesaurus, "jk l");
        Thesaurus abc2 = this.createThesaurus("ab c", jkl.getWikittyId(), (RootThesaurus)rootThesaurus, "ab c");
        Thesaurus def2 = this.createThesaurus("de f", jkl.getWikittyId(), (RootThesaurus)rootThesaurus, "de f");
        Thesaurus ghi2 = this.createThesaurus("gh & i", jkl.getWikittyId(), (RootThesaurus)rootThesaurus, "gh & i");
        FormPagedResult result = this.testSearch("acheteur:(\"Ville de Nogent sur Marne\")");
        String formId1 = (String)result.getFormsIdsToShow().get(0);
        Form form1 = (Form)this.wikittyProxy.restore(Form.class, formId1);
        abc.addAttachment(form1.getWikittyId());
        ghi.addAttachment(form1.getWikittyId());
        abc = (Thesaurus)this.wikittyProxy.store((BusinessEntity)abc);
        ghi = (Thesaurus)this.wikittyProxy.store((BusinessEntity)ghi);
        result = this.testSearch("acheteur:(\"Ville de Saint Joseph\")");
        String formId2 = (String)result.getFormsIdsToShow().get(0);
        Form form2 = (Form)this.wikittyProxy.restore(Form.class, formId2);
        jkl.addAttachment(form2.getWikittyId());
        ghi2.addAttachment(form2.getWikittyId());
        jkl = (Thesaurus)this.wikittyProxy.store((BusinessEntity)jkl);
        ghi2 = (Thesaurus)this.wikittyProxy.store((BusinessEntity)ghi2);
        result = this.testSearch("acheteur:Infocom94");
        String formIds3 = (String)result.getFormsIdsToShow().get(0);
        Form form3 = (Form)this.wikittyProxy.restore(Form.class, formIds3);
        def.addAttachment(form3.getWikittyId());
        abc2.addAttachment(form3.getWikittyId());
        def = (Thesaurus)this.wikittyProxy.store((BusinessEntity)def);
        abc2 = (Thesaurus)this.wikittyProxy.store((BusinessEntity)abc2);
        this.testSearch("thesaurus:(\"ab c\")", 3);
        this.testSearch("thesaurus:(\"de f\")", 1);
        this.testSearch("thesaurus:(\"gh \\& i\")", 2);
        this.testSearch("thesaurus:(\"jk l\")", 2);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"gh \\& i\")", 2);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"gh \\& i\")", 3);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"de f\")", 1);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"de f\")", 3);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"jk l\")", 2);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"jk l\")", 3);
        this.testSearch("thesaurus:(\"de f\") OR thesaurus:(\"gh \\& i\")", 3);
        this.testSearch("thesaurus:(\"pas de resultat\")", 0);
    }

    @Test
    public void testSearchMultiThesaurus() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        this.testSearch("", 5);
        RootThesaurusImpl rootThesaurus = new RootThesaurusImpl();
        rootThesaurus.setName("thesaurus");
        this.wikittyProxy.store((BusinessEntity)rootThesaurus);
        Thesaurus abc = this.createThesaurus("abc1", null, (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus def = this.createThesaurus("def1", abc.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus ghi = this.createThesaurus("ghi1", abc.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        RootThesaurusImpl rootDescripteur = new RootThesaurusImpl();
        rootDescripteur.setName("Descripteurs");
        this.wikittyProxy.store((BusinessEntity)rootDescripteur);
        Thesaurus abc2 = this.createThesaurus("abc2", null, (RootThesaurus)rootDescripteur, new String[0]);
        Thesaurus def2 = this.createThesaurus("def2", abc2.getWikittyId(), (RootThesaurus)rootDescripteur, new String[0]);
        Thesaurus ghi2 = this.createThesaurus("ghi2", def2.getWikittyId(), (RootThesaurus)rootDescripteur, new String[0]);
        FormPagedResult result = this.testSearch("acheteur:(\"Ville de Nogent sur Marne\")");
        String formId1 = (String)result.getFormsIdsToShow().get(0);
        Form form1 = (Form)this.wikittyProxy.restore(Form.class, formId1);
        abc.addAttachment(form1.getWikittyId());
        ghi.addAttachment(form1.getWikittyId());
        abc = (Thesaurus)this.wikittyProxy.store((BusinessEntity)abc);
        ghi = (Thesaurus)this.wikittyProxy.store((BusinessEntity)ghi);
        result = this.testSearch("acheteur:(\"Ville de Saint Joseph\")");
        String formIds2 = (String)result.getFormsIdsToShow().get(0);
        Form form2 = (Form)this.wikittyProxy.restore(Form.class, formIds2);
        ghi2.addAttachment(form2.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)form2);
        ghi2 = (Thesaurus)this.wikittyProxy.store((BusinessEntity)ghi2);
        result = this.testSearch("acheteur:Infocom94");
        String formIds3 = (String)result.getFormsIdsToShow().get(0);
        Form form3 = (Form)this.wikittyProxy.restore(Form.class, formIds3);
        def.addAttachment(form3.getWikittyId());
        abc2.addAttachment(form3.getWikittyId());
        def = (Thesaurus)this.wikittyProxy.store((BusinessEntity)def);
        abc2 = (Thesaurus)this.wikittyProxy.store((BusinessEntity)abc2);
        this.testSearch("Thesaurus:(\"abc1\")", 2);
        this.testSearch("thesaurus:(\"ghi1\")", 1);
        this.testSearch("thesaurus:(\"none\")", 0);
        this.testSearch("descripteurs:(\"ghi2\")", 1);
        this.testSearch("descripteurs:(\"none\")", 0);
        this.testSearch("toto:(\"titi\")", 0);
        this.testSearch("toto:(\"abc1\")", 0);
        this.testSearch("toto:(\"abc2\")", 0);
        this.testSearch("thesaurus:abc*", 2);
        this.testSearch("descripteurs:abc*", 2);
    }

    @Test
    public void testQueryArchiving() throws Exception {
        this.createClient("Client", "test1", "test2");
        this.createUser("User", "test1", "test2");
        this.createGroup("Group", "test1", "test2");
    }

    @Test
    public void testExportAsCSV() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Search search = Search.query().keyword("*");
        Criteria criteria = search.criteria();
        String exportString = this.storageService.exportAsCSV(criteria);
        Assert.assertNotNull((Object)exportString);
        Assert.assertTrue((exportString.indexOf("annonce.description") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImportAsCSV() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        URL importURL = VradiStorageServiceTest.class.getResource("/csv/testimport.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        Search search = Search.query().keyword("*");
        Criteria criteria = search.criteria();
        String exportString = this.storageService.exportAsCSV(criteria);
        FileUtils.writeStringToFile((File)File.createTempFile("exportimport", ".csv"), (String)exportString);
        Assert.assertNotNull((Object)exportString);
        Assert.assertTrue((exportString.indexOf("TATA TOTO") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImportAsCSVWithQueries() throws Exception {
        this.wikittyProxy.storeExtension(ClientImpl.extensionClient);
        this.wikittyProxy.storeExtension(UserImpl.extensionUser);
        this.wikittyProxy.storeExtension(ModificationTagImpl.extensionModificationTag);
        this.wikittyProxy.storeExtension(QueryMakerImpl.extensionQueryMaker);
        URL importURL = VradiStorageServiceTest.class.getResource("/csv/clients.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        importURL = VradiStorageServiceTest.class.getResource("/csv/users.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        Search lookingForEric = Search.query().eq("User.name", "Eric Chatellier");
        User eric = (User)this.wikittyProxy.findByCriteria(User.class, lookingForEric.criteria());
        String codeLutinId = eric.getClient();
        Client codeLutin = (Client)this.wikittyProxy.restore(Client.class, codeLutinId);
        Assert.assertNotNull((Object)codeLutin);
        Assert.assertEquals((Object)"Code Lutin", (Object)codeLutin.getName());
        Search pierreSearch = Search.query().eq("User.name", "Pierre Cros");
        User pierre = (User)this.wikittyProxy.findByCriteria(User.class, pierreSearch.criteria());
        String libreEntrepriseId = pierre.getClient();
        Client libreEntreprise = (Client)this.wikittyProxy.restore(Client.class, libreEntrepriseId);
        Assert.assertNotNull((Object)libreEntreprise);
        Assert.assertEquals((Object)"Libre entreprise", (Object)libreEntreprise.getName());
    }

    @Test
    public void testImportAsCSVWithExtension() throws Exception {
        this.wikittyProxy.storeExtension(WikittyTreeNodeImpl.extensionWikittyTreeNode);
        this.wikittyProxy.storeExtension(ThesaurusImpl.extensionThesaurus);
        this.wikittyProxy.storeExtension(RootThesaurusImpl.extensionRootThesaurus);
        URL importURL = VradiStorageServiceTest.class.getResource("/csv/thesaurus.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        List rootThesaurus = this.dataService.getRootThesaurus();
        Assert.assertEquals((long)1L, (long)rootThesaurus.size());
        Assert.assertEquals((Object)"TestRootThesaurus", (Object)((RootThesaurus)rootThesaurus.get(0)).getName());
        Assert.assertTrue((boolean)this.dataService.isThesaurusNameExistsInRootThesaurus((RootThesaurus)rootThesaurus.get(0), "Foot"));
        Assert.assertFalse((boolean)this.dataService.isThesaurusNameExistsInRootThesaurus((RootThesaurus)rootThesaurus.get(0), "Rugby"));
    }

    @Test
    public void testGetChildrenCartography() throws Exception {
        RootThesaurusImpl rootThesaurus = new RootThesaurusImpl();
        rootThesaurus.setName("MyThesaurus");
        this.wikittyProxy.store((BusinessEntity)rootThesaurus);
        WikittyExtension extension = this.createFileFormType();
        WikittyExtension thesaurusExtension = this.createThesaurusExtension();
        XmlStreamImportResult initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData.getCreatedFormCount());
        Thesaurus tDomaine = this.createThesaurus("Domaine", rootThesaurus.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tScience = this.createThesaurus("Science", tDomaine.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tHistoire = this.createThesaurus("Histoire", tDomaine.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tSport = this.createThesaurus("Sport", tDomaine.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tTennisDeTable = this.createThesaurus("Tennis de table", tSport.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tTennis = this.createThesaurus("Tennis", tSport.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tFoot = this.createThesaurus("Foot", tSport.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tFootSalle = this.createThesaurus("Foot en salle", tFoot.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        Thesaurus tFootExterieur = this.createThesaurus("Foot en ext\u00e9rieur", tFoot.getWikittyId(), (RootThesaurus)rootThesaurus, new String[0]);
        FormPagedResult result1 = this.testSearch("size:203");
        String formId1 = (String)result1.getFormsIdsToShow().get(0);
        tFootExterieur.addAttachment(formId1);
        tFootExterieur = (Thesaurus)this.wikittyProxy.store((BusinessEntity)tFootExterieur);
        FormPagedResult result2 = this.testSearch("size:125");
        String formId2 = (String)result2.getFormsIdsToShow().get(0);
        tFootSalle.addAttachment(formId2);
        tFootSalle = (Thesaurus)this.wikittyProxy.store((BusinessEntity)tFootSalle);
        QueryParameters queryParameters = new QueryParameters("size:125 OR size:203");
        Map childrenCartography = this.dataService.getChildrenCartography(tSport.getWikittyId(), queryParameters);
        Assert.assertEquals((long)2L, (long)((Integer)childrenCartography.get(tFoot)).intValue());
        queryParameters = new QueryParameters("MyThesaurus:Domaine");
        childrenCartography = this.dataService.getChildrenCartography(rootThesaurus.getWikittyId(), queryParameters);
        Assert.assertEquals((long)2L, (long)((Integer)childrenCartography.get(tDomaine)).intValue());
    }

    @Ignore
    public void testBasicFeedImport() throws Exception {
        try {
            String leMondeUneFeed = "http://www.lemonde.fr/rss/une.xml";
            URL leMondeUneURL = new URL(leMondeUneFeed);
            WikittyExtension extension = this.createAnnonceFormType();
            List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
            XmlStream xmlStream = this.createXmlStream(extension, bindings, leMondeUneURL);
            XmlStreamImportResult importResult = this.storageService.importFormsFromXmlStream(xmlStream);
            Assert.assertTrue((importResult.getCreatedFormCount() > 0 ? 1 : 0) != 0);
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof UnknownHostException) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No internet connection, skip test", (Throwable)eee);
                }
            }
            throw eee;
        }
    }

    @Test
    public void testHttpsFeedImport() throws Exception {
        try {
            String labsFeed = "https://labs.libre-entreprise.org/export/rss_sfnews.php";
            URL labsURL = new URL(labsFeed);
            WikittyExtension extension = this.createAnnonceFormType();
            List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
            XmlStream xmlStream = this.createXmlStream(extension, bindings, labsURL);
            XmlStreamImportResult importResult = this.storageService.importFormsFromXmlStream(xmlStream);
            Assert.assertTrue((importResult.getCreatedFormCount() > 0 ? 1 : 0) != 0);
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof UnknownHostException) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No internet connection, skip test", (Throwable)eee);
                }
            }
            throw eee;
        }
    }

    @Test
    public void testAdditionalFeedImport() throws Exception {
        try {
            String gentooFeed = "http://www.gentoo.org/rdf/en/gentoo-news.rdf";
            URL gentooURL = new URL(gentooFeed);
            WikittyExtension extension = this.createAnnonceFormType();
            List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
            XmlStream xmlStream = this.createXmlStream(extension, bindings, gentooURL);
            XmlStreamImportResult importResult = this.storageService.importFormsFromXmlStream(xmlStream);
            Assert.assertTrue((importResult.getCreatedFormCount() > 0 ? 1 : 0) != 0);
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof UnknownHostException) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No internet connection, skip test", (Throwable)eee);
                }
            }
            throw eee;
        }
    }

    protected WikittyExtension createPersonneFormType() throws Exception {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("nom", FieldTypeEnum.STRING.getFieldType());
        fields.put("prenom", FieldTypeEnum.STRING.getFieldType());
        return this.createFormType("Personne", fields);
    }

    @Test
    public void testFieldNames() throws Exception {
        URL resource = VradiStorageServiceTest.class.getResource("/ooo/test.ott");
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)resource, (File)localFile);
        try {
            WikittyExtension extension = this.createPersonneFormType();
            this.fileService.uploadTemplate(localFile, extension.getName());
            List fieldNames = this.storageService.getDocumentFields(extension, localFile.getName());
            Assert.assertEquals((long)fieldNames.size(), (long)2L);
            Assert.assertEquals(fieldNames.get(0), (Object)"nom");
            Assert.assertEquals(fieldNames.get(1), (Object)"prenom");
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    @Test
    public void testFieldNames2() throws Exception {
        URL resource = VradiStorageServiceTest.class.getResource("/ooo/vradi_template.odt");
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)resource, (File)localFile);
        try {
            WikittyExtension extension = this.createPersonneFormType();
            this.fileService.uploadTemplate(localFile, extension.getName());
            List fieldNames = this.storageService.getDocumentFields(extension, localFile.getName());
            Assert.assertEquals((long)fieldNames.size(), (long)8L);
            Assert.assertEquals(fieldNames.get(0), (Object)"acheteur");
            Assert.assertEquals(fieldNames.get(1), (Object)"objet");
            Assert.assertEquals(fieldNames.get(2), (Object)"description");
            Assert.assertEquals(fieldNames.get(3), (Object)"departement");
            Assert.assertEquals(fieldNames.get(4), (Object)"id");
            Assert.assertEquals(fieldNames.get(5), (Object)"url");
            Assert.assertEquals(fieldNames.get(6), (Object)"date");
            Assert.assertEquals(fieldNames.get(7), (Object)"test");
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    @Test
    public void testFieldNames3() throws Exception {
        URL resource = VradiStorageServiceTest.class.getResource("/ooo/modelePDF2.odt");
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)resource, (File)localFile);
        try {
            WikittyExtension extension = this.createPersonneFormType();
            this.fileService.uploadTemplate(localFile, extension.getName());
            List fieldNames = this.storageService.getDocumentFields(extension, localFile.getName());
            Assert.assertEquals((long)fieldNames.size(), (long)0L);
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    @Test
    public void testFieldNamesPossibilities() throws Exception {
        URL resource = VradiStorageServiceTest.class.getResource("/ooo/variousfieldtypes.odt");
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)resource, (File)localFile);
        try {
            WikittyExtension extension = this.createPersonneFormType();
            this.fileService.uploadTemplate(localFile, extension.getName());
            List fieldNames = this.storageService.getDocumentFields(extension, localFile.getName());
            Assert.assertEquals((long)fieldNames.size(), (long)2L);
            Assert.assertEquals(fieldNames.get(0), (Object)"usertexte");
            Assert.assertEquals(fieldNames.get(1), (Object)"userstd");
        }
        catch (VradiException eee) {
            if (eee.getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    @Test
    public void testGeneration() throws Exception {
        URL resource = VradiStorageServiceTest.class.getResource("/ooo/test.ott");
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)resource, (File)localFile);
        try {
            WikittyExtension formType = this.createPersonneFormType();
            formType.addTagValue("template", localFile.getName());
            this.dataService.updateFormType(formType);
            FormImpl form = new FormImpl();
            Wikitty wikitty = form.getWikitty();
            wikitty.addExtension(formType);
            form.setField("Personne", "nom", (Object)"Morin");
            form.setField("Personne", "prenom", (Object)"Kevin");
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("nom", "Personne.nom");
            fieldMap.put("prenom", "Personne.prenom");
            this.fileService.uploadTemplate(localFile, formType.getName());
            this.storageService.setAssociatedFields(formType.getName(), localFile.getName(), fieldMap);
            form = (FormImpl)this.wikittyProxy.store((BusinessEntity)form);
            String uri = this.storageService.generatePDF(form.getWikittyId(), true);
            File pdfFile = this.fileService.downloadPDF(uri);
            Assert.assertNotNull((Object)pdfFile);
            Assert.assertTrue((boolean)pdfFile.exists());
        }
        catch (VradiException eee) {
            if (eee.getCause().getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    public void testPostMessage() throws VradiException {
        MailingManager mailingManager = new MailingManager(null);
        mailingManager.postMail("toto@codelutin.com", "test", "ceci est un test", null, true);
    }

    public void testReceiveMessages() throws VradiException {
        this.storageService.receiveMessages();
    }

    @Test
    public void testTemplatesAttachments() throws Exception {
        File localFile = File.createTempFile("local-file", ".ott");
        localFile.deleteOnExit();
        FileUtils.copyURLToFile((URL)VradiStorageServiceTest.class.getResource("/ooo/test.ott"), (File)localFile);
        File image1 = File.createTempFile("local-image1", ".ott");
        File image2 = File.createTempFile("local-image2", ".ott");
        File image3 = File.createTempFile("local-image3", ".ott");
        image1.deleteOnExit();
        image2.deleteOnExit();
        image3.deleteOnExit();
        FileUtils.copyURLToFile((URL)VradiStorageServiceTest.class.getResource("/images/enregistrement.png"), (File)image1);
        FileUtils.copyURLToFile((URL)VradiStorageServiceTest.class.getResource("/images/flux.gif"), (File)image2);
        FileUtils.copyURLToFile((URL)VradiStorageServiceTest.class.getResource("/images/form.jpg"), (File)image3);
        try {
            WikittyExtension formType = this.createPersonneFormType();
            formType.addTagValue("template", localFile.getName());
            this.dataService.updateFormType(formType);
            FormImpl form = new FormImpl();
            Wikitty wikitty = form.getWikitty();
            wikitty.addExtension(formType);
            form.setField("Personne", "nom", (Object)"John");
            form.setField("Personne", "prenom", (Object)"Doe");
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("nom", "Personne.nom");
            fieldMap.put("prenom", "Personne.prenom");
            this.fileService.uploadFormEmbeddedFile(image1, form.getWikittyId());
            this.fileService.uploadFormEmbeddedFile(image2, form.getWikittyId());
            this.fileService.uploadFormEmbeddedFile(image3, form.getWikittyId());
            form.addFiles(image1.getName());
            form.addFiles(image2.getName());
            form.addFiles(image3.getName());
            this.fileService.uploadTemplate(localFile, formType.getName());
            this.storageService.setAssociatedFields(formType.getName(), localFile.getName(), fieldMap);
            form = (FormImpl)this.wikittyProxy.store((BusinessEntity)form);
            String uri = this.storageService.generatePDF(form.getWikittyId(), true);
            File pdfFile = this.fileService.downloadPDF(uri);
            Assert.assertNotNull((Object)pdfFile);
            Assert.assertTrue((boolean)pdfFile.exists());
        }
        catch (VradiException eee) {
            if (eee.getCause().getCause() instanceof BootstrapException) {
                log.error((Object)"OOo cannot be loaded : ", (Throwable)eee);
            }
            throw eee;
        }
    }

    @Test
    public void testCreateSendingForUser() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Date date = new Date();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        UserImpl user = new UserImpl();
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("*");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        Sending sending = this.storageService.createSending(session.getWikittyId(), (User)user, formsIds);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Set sendingsFromSession = session.getSending();
        Assert.assertNotNull((Object)sendingsFromSession);
        Assert.assertEquals((long)1L, (long)sendingsFromSession.size());
        Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((Object)user.getWikittyId(), (Object)sending.getUser());
        Assert.assertEquals((long)5L, (long)sendingForms.size());
    }

    @Test
    public void testCreateSendingForGroup() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Session session = this.storageService.createNewSession();
        GroupImpl group = new GroupImpl();
        UserImpl user = new UserImpl();
        group.addUser(user.getWikittyId());
        user = (User)this.wikittyProxy.store((BusinessEntity)user);
        group = (Group)this.wikittyProxy.store((BusinessEntity)group);
        session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("*");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List sendings = this.storageService.createAllSending(session.getWikittyId(), (Group)group, formsIds);
        Assert.assertEquals((long)1L, (long)sendings.size());
        Sending sending = (Sending)sendings.get(0);
        Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((long)5L, (long)sendingForms.size());
        Assert.assertEquals((Object)user.getWikittyId(), (Object)sending.getUser());
    }

    @Test
    public void testCreateSendingForGroupWithAlreadyCreatedSendings() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Session session = this.storageService.createNewSession();
        GroupImpl group = new GroupImpl();
        UserImpl user1 = new UserImpl();
        UserImpl user2 = new UserImpl();
        UserImpl user3 = new UserImpl();
        this.wikittyProxy.store((BusinessEntity)user1);
        this.wikittyProxy.store((BusinessEntity)user2);
        this.wikittyProxy.store((BusinessEntity)user3);
        this.wikittyProxy.store((BusinessEntity)session);
        group.addUser(user1.getWikittyId());
        group.addUser(user2.getWikittyId());
        group.addUser(user3.getWikittyId());
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("*");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List sendings = this.storageService.createAllSending(session.getWikittyId(), (Group)group, formsIds);
        Assert.assertEquals((long)3L, (long)sendings.size());
        Sending sending = (Sending)sendings.get(0);
        Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((long)5L, (long)sendingForms.size());
    }

    @Test
    public void testRemoveAllSendingsOnUser() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Date date = new Date();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        this.wikittyProxy.store((BusinessEntity)session);
        UserImpl user = new UserImpl();
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("*");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        Sending sending = this.storageService.createSending(session.getWikittyId(), (User)user, formsIds);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Set sendingsFromSession = session.getSending();
        Assert.assertNotNull((Object)sendingsFromSession);
        Assert.assertEquals((long)1L, (long)sendingsFromSession.size());
        Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((long)5L, (long)sendingForms.size());
        ArrayList formId = new ArrayList();
        formId.add(formsIds.get(0));
        sending = this.storageService.removeSending(session.getWikittyId(), formId, (User)user);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Assert.assertEquals((long)1L, (long)session.getSending().size());
        Set sendingForms2 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((long)4L, (long)sendingForms2.size());
    }

    @Test
    public void testRemoveAllSendingsOnGroup() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Date date = new Date();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        this.wikittyProxy.store((BusinessEntity)session);
        GroupImpl group = new GroupImpl();
        UserImpl user1 = new UserImpl();
        UserImpl user2 = new UserImpl();
        UserImpl user3 = new UserImpl();
        this.wikittyProxy.store((BusinessEntity)user1);
        this.wikittyProxy.store((BusinessEntity)user2);
        this.wikittyProxy.store((BusinessEntity)user3);
        group.addUser(user1.getWikittyId());
        group.addUser(user2.getWikittyId());
        group.addUser(user3.getWikittyId());
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("*");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List sendings = this.storageService.createAllSending(session.getWikittyId(), (Group)group, formsIds);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Assert.assertEquals((long)3L, (long)sendings.size());
        Set sendingsFromSession = session.getSending();
        Assert.assertNotNull((Object)sendingsFromSession);
        Assert.assertEquals((long)3L, (long)sendingsFromSession.size());
        Sending sending = (Sending)sendings.get(0);
        Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
        Assert.assertEquals((long)5L, (long)sendingForms.size());
        ArrayList formId = new ArrayList();
        formId.add(formsIds.get(0));
        sendings = this.storageService.removeAllSending(session.getWikittyId(), formId, (Group)group);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Assert.assertEquals((long)3L, (long)sendings.size());
        Assert.assertEquals((long)3L, (long)session.getSending().size());
        Set sendingForms0 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(0)).getGroupForms());
        Set sendingForms1 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(1)).getGroupForms());
        Set sendingForms2 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(2)).getGroupForms());
        Assert.assertEquals((long)4L, (long)sendingForms0.size());
        Assert.assertEquals((long)4L, (long)sendingForms1.size());
        Assert.assertEquals((long)4L, (long)sendingForms2.size());
    }

    @Test
    public void testDeleteSession() throws Exception {
        List sendings2;
        Session session2;
        block2: {
            WikittyExtension extension = this.createAnnonceFormType();
            this.initData(extension);
            Session session = this.storageService.createNewSession();
            GroupImpl group = new GroupImpl();
            UserImpl user1 = new UserImpl();
            UserImpl user2 = new UserImpl();
            UserImpl user3 = new UserImpl();
            this.wikittyProxy.store((BusinessEntity)user1);
            this.wikittyProxy.store((BusinessEntity)user2);
            this.wikittyProxy.store((BusinessEntity)user3);
            this.wikittyProxy.store((BusinessEntity)session);
            group.addUser(user1.getWikittyId());
            group.addUser(user2.getWikittyId());
            group.addUser(user3.getWikittyId());
            FormPagedResult formPagedResult = new FormPagedResult();
            QueryParameters queryParameters = new QueryParameters("*");
            formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
            List formsIds = formPagedResult.getFormsIdsToShow();
            List sendings = this.storageService.createAllSending(session.getWikittyId(), (Group)group, formsIds);
            this.storageService.deleteSession(session.getWikittyId());
            Session sessionRestored = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
            Assert.assertNull((Object)sessionRestored);
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, ((Sending)sendings.get(0)).getWikittyId());
            Assert.assertNull((Object)sending);
            session2 = this.storageService.createNewSession();
            session2.setStatus(VradiConstants.SessionStatus.ERROR.getValue());
            session2 = (Session)this.wikittyProxy.store((BusinessEntity)session2);
            sendings2 = this.storageService.createAllSending(session2.getWikittyId(), (Group)group, formsIds);
            try {
                this.storageService.deleteSession(session2.getWikittyId());
                Assert.fail((String)"Session in error is deleted");
            }
            catch (VradiException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't delete status in error", (Throwable)eee);
            }
        }
        Session session2Restored = (Session)this.wikittyProxy.restore(Session.class, session2.getWikittyId());
        Sending sending2 = (Sending)this.wikittyProxy.restore(Sending.class, ((Sending)sendings2.get(0)).getWikittyId());
        Assert.assertNotNull((Object)session2Restored);
        Assert.assertNotNull((Object)sending2);
    }

    @Test
    public void testArchiveQueries() throws Exception {
        GroupImpl group = new GroupImpl();
        group.setName("Groupe de test");
        QueryBean bean = new QueryBean("titi,tata,ALONZEAU");
        group.addQueries(bean.getCSVQuery());
        this.storageService.archiveQueries((QueryMaker)group);
        File history = this.fileService.downloadRequestHistory(group.getWikittyId() + ".rss");
        Assert.assertTrue((boolean)history.exists());
        List lines = FileUtils.readLines((File)history);
        Assert.assertEquals((long)17L, (long)lines.size());
        Assert.assertEquals((Object)"    <title>Requetes de Groupe de test</title>", lines.get(3));
        Assert.assertEquals((Object)"      <description>&lt;ul&gt;&lt;li&gt;&lt;name&gt;&lt;![CDATA[tata]]&lt;/name&gt;&lt;description&gt;&lt;![CDATA[ALONZEAU]]&lt;/description&gt;&lt;query&gt;&lt;![CDATA[titi]]&lt;/query&gt;&lt;/li&gt;&lt;/ul&gt;</description>", lines.get(10));
    }

    @Test(expected=VradiException.class)
    public void testNewSessionFail() throws VradiException {
        this.storageService.createNewSession();
        this.storageService.createNewSession();
    }

    @Test
    public void testBindFormNormalUse() throws Exception {
        Date beginSearchDate = DateUtils.addDays((Date)new Date(), (int)-2);
        ClientImpl testClient = new ClientImpl();
        testClient.setName("Bayern Munchen");
        testClient = (Client)this.wikittyProxy.store((BusinessEntity)testClient);
        UserImpl testUser = new UserImpl();
        testUser.setName("Franck Ribery");
        testUser.setClient(testClient.getWikittyId());
        testUser.setEnable(true);
        testUser.setBeginSearchDate(beginSearchDate);
        testUser = (User)this.wikittyProxy.store((BusinessEntity)testUser);
        GroupImpl testGroup = new GroupImpl();
        testGroup.setName("Zahia fans");
        QueryBean bean = new QueryBean("ALONZEAU,tata,titi");
        testGroup.addQueries(bean.getCSVQuery());
        testGroup.addUser(testUser.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)testGroup);
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Session session = this.storageService.createNewSession();
        session = this.storageService.bindForms(session);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)1L, (long)session.getNum());
        Set sendings = session.getSending();
        Assert.assertNull((Object)sendings);
        session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        this.wikittyProxy.store((BusinessEntity)session);
        Status selectionne = this.dataService.getStatus(VradiConstants.FormStatus.SELECTIONNE);
        String formId = "";
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("ALONZEAU");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            formId = form.getWikittyId();
            form.setStatus(selectionne.getWikittyId());
            form.setDatePub(new Date());
            this.wikittyProxy.store((BusinessEntity)form);
        }
        formPagedResult = new FormPagedResult();
        queryParameters = new QueryParameters("ALONZEAU");
        queryParameters.setStatusIds(Collections.singletonList(selectionne.getWikittyId()));
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        Assert.assertEquals((long)1L, (long)formPagedResult.getFormsIdsToShow().size());
        Session session2 = this.storageService.createNewSession();
        session2 = this.storageService.bindForms(session2);
        Assert.assertNotNull((Object)session2);
        Assert.assertEquals((long)2L, (long)session2.getNum());
        sendings = session2.getSending();
        Assert.assertNotNull((Object)sendings);
        Assert.assertEquals((long)1L, (long)sendings.size());
        for (String sendingId : sendings) {
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
            Set sendingForms = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms());
            Assert.assertNotNull((Object)sendingForms);
            Assert.assertEquals((long)1L, (long)sendingForms.size());
            Assert.assertTrue((boolean)sendingForms.contains(formId));
        }
    }

    @Test
    public void testBindingValidityDate() throws Exception {
        Date now = new Date();
        Date beginSearchDate = DateUtils.addDays((Date)now, (int)-100);
        Date datePub = DateUtils.addDays((Date)now, (int)-10);
        Date datePer = DateUtils.addDays((Date)now, (int)-2);
        ClientImpl testClient = new ClientImpl();
        testClient.setName("Bayern Munchen");
        testClient = (Client)this.wikittyProxy.store((BusinessEntity)testClient);
        UserImpl testUser = new UserImpl();
        testUser.setName("Franck Ribery");
        testUser.setClient(testClient.getWikittyId());
        testUser.setEnable(true);
        testUser.setBeginSearchDate(beginSearchDate);
        testUser = (User)this.wikittyProxy.store((BusinessEntity)testUser);
        GroupImpl testGroup = new GroupImpl();
        testGroup.setName("Zahia fans");
        QueryBean bean = new QueryBean("ALONZEAU,tata,titi");
        testGroup.addQueries(bean.getCSVQuery());
        testGroup.addUser(testUser.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)testGroup);
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Status selectionne = this.dataService.getStatus(VradiConstants.FormStatus.SELECTIONNE);
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("ALONZEAU");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            form.setStatus(selectionne.getWikittyId());
            form.setDatePub(datePub);
            form.setDatePeremption(datePer);
            this.wikittyProxy.store((BusinessEntity)form);
        }
        formPagedResult = new FormPagedResult();
        queryParameters = new QueryParameters("ALONZEAU");
        queryParameters.setStatusIds(Collections.singletonList(selectionne.getWikittyId()));
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        Assert.assertEquals((long)1L, (long)formPagedResult.getFormsIdsToShow().size());
        Session session = this.storageService.createNewSession();
        session = this.storageService.bindForms(session);
        Assert.assertNotNull((Object)session);
        Assert.assertNull((Object)session.getSending());
    }

    @Test
    public void testBindingModificationDate() throws Exception {
        Date now = new Date();
        Date beginSearchDate = DateUtils.addDays((Date)now, (int)3);
        Date datePub = DateUtils.addDays((Date)now, (int)-10);
        Date datePer = DateUtils.addDays((Date)now, (int)2);
        ClientImpl testClient = new ClientImpl();
        testClient.setName("Bayern Munchen");
        testClient = (Client)this.wikittyProxy.store((BusinessEntity)testClient);
        UserImpl testUser = new UserImpl();
        testUser.setName("Franck Ribery");
        testUser.setClient(testClient.getWikittyId());
        testUser.setEnable(true);
        testUser.setBeginSearchDate(beginSearchDate);
        testUser = (User)this.wikittyProxy.store((BusinessEntity)testUser);
        GroupImpl testGroup = new GroupImpl();
        testGroup.setName("Zahia fans");
        QueryBean bean = new QueryBean("ALONZEAU,tata,titi");
        testGroup.addQueries(bean.getCSVQuery());
        testGroup.addUser(testUser.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)testGroup);
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Status selectionne = this.dataService.getStatus(VradiConstants.FormStatus.SELECTIONNE);
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("ALONZEAU");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            form.setStatus(selectionne.getWikittyId());
            form.setDatePub(datePub);
            form.setDatePeremption(datePer);
            ModificationTag formTag = (ModificationTag)this.wikittyProxy.cast((BusinessEntity)form, ModificationTag.class);
            formTag.setLastModified(new Date());
            this.wikittyProxy.store((BusinessEntity)form);
        }
        formPagedResult = new FormPagedResult();
        queryParameters = new QueryParameters("ALONZEAU");
        queryParameters.setStatusIds(Collections.singletonList(selectionne.getWikittyId()));
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        Assert.assertEquals((long)1L, (long)formPagedResult.getFormsIdsToShow().size());
        Session session = this.storageService.createNewSession();
        session = this.storageService.bindForms(session);
        Assert.assertNotNull((Object)session);
        Assert.assertNull((Object)session.getSending());
    }

    @Test
    public void testBindingUserPeremptionDate() throws Exception {
        Date now = new Date();
        Date beginSearchDate = DateUtils.addDays((Date)now, (int)-10);
        Date datePub = DateUtils.addDays((Date)now, (int)-1);
        Date datePer = DateUtils.addDays((Date)now, (int)-1);
        ClientImpl testClient = new ClientImpl();
        testClient.setName("Bayern Munchen");
        testClient = (Client)this.wikittyProxy.store((BusinessEntity)testClient);
        UserImpl testUser = new UserImpl();
        testUser.setName("Franck Ribery");
        testUser.setClient(testClient.getWikittyId());
        testUser.setEnable(true);
        testUser.setBeginSearchDate(beginSearchDate);
        testUser = (User)this.wikittyProxy.store((BusinessEntity)testUser);
        GroupImpl testGroup = new GroupImpl();
        testGroup.setName("Zahia fans");
        QueryBean bean = new QueryBean("ALONZEAU,tata,titi");
        testGroup.addQueries(bean.getCSVQuery());
        testGroup.addUser(testUser.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)testGroup);
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Status selectionne = this.dataService.getStatus(VradiConstants.FormStatus.SELECTIONNE);
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("ALONZEAU");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        List forms = this.wikittyProxy.restore(Form.class, formsIds);
        for (Form form : forms) {
            form.setStatus(selectionne.getWikittyId());
            form.setDatePub(datePub);
            form.setDatePeremption(datePer);
            this.wikittyProxy.store((BusinessEntity)form);
        }
        formPagedResult = new FormPagedResult();
        queryParameters = new QueryParameters("ALONZEAU");
        queryParameters.setStatusIds(Collections.singletonList(selectionne.getWikittyId()));
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        Assert.assertEquals((long)1L, (long)formPagedResult.getFormsIdsToShow().size());
        Session session = this.storageService.createNewSession();
        session = this.storageService.bindForms(session);
        Assert.assertNotNull((Object)session);
        Assert.assertNull((Object)session.getSending());
    }

    @Test
    public void testRemoveFormsFromSession() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Date date = new Date();
        SessionImpl session = new SessionImpl();
        session.setSessionDate(date);
        session.setNum(0);
        session.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        this.wikittyProxy.store((BusinessEntity)session);
        GroupImpl group = new GroupImpl();
        QueryBean bean = new QueryBean("*,*,*");
        group.addQueries(bean.getCSVQuery());
        Date now = new Date();
        Date beginSearchDate = DateUtils.addDays((Date)now, (int)-10);
        Date datePub = DateUtils.addDays((Date)now, (int)-1);
        UserImpl user1 = new UserImpl();
        user1.setEnable(true);
        user1.setBeginSearchDate(beginSearchDate);
        UserImpl user2 = new UserImpl();
        user2.setEnable(true);
        user2.setBeginSearchDate(beginSearchDate);
        UserImpl user3 = new UserImpl();
        user3.setEnable(true);
        user3.setBeginSearchDate(beginSearchDate);
        this.wikittyProxy.store((BusinessEntity)user1);
        this.wikittyProxy.store((BusinessEntity)user2);
        this.wikittyProxy.store((BusinessEntity)user3);
        group.addUser(user1.getWikittyId());
        group.addUser(user2.getWikittyId());
        group.addUser(user3.getWikittyId());
        this.wikittyProxy.store((BusinessEntity)group);
        FormPagedResult formPagedResult = new FormPagedResult();
        QueryParameters queryParameters = new QueryParameters("adjudicateur");
        formPagedResult = this.dataService.findForms(queryParameters, formPagedResult);
        List formsIds = formPagedResult.getFormsIdsToShow();
        Status selectionne = this.dataService.getStatus(VradiConstants.FormStatus.SELECTIONNE);
        FormPagedResult allFormPagedResult = new FormPagedResult();
        QueryParameters allQueryParameters = new QueryParameters("*");
        allFormPagedResult = this.dataService.findForms(allQueryParameters, allFormPagedResult);
        List allFormsIds = allFormPagedResult.getFormsIdsToShow();
        List allForms = this.wikittyProxy.restore(Form.class, allFormsIds);
        for (Form form : allForms) {
            form.setStatus(selectionne.getWikittyId());
            form.setDatePub(datePub);
            form.setCreationDate(datePub);
            this.wikittyProxy.store((BusinessEntity)form);
        }
        List sendings = this.storageService.createAllSending(session.getWikittyId(), (Group)group, formsIds);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        Assert.assertEquals((long)3L, (long)sendings.size());
        Set sendingsFromSession = session.getSending();
        Assert.assertNotNull((Object)sendingsFromSession);
        Assert.assertEquals((long)3L, (long)sendingsFromSession.size());
        Sending sending0 = (Sending)sendings.get(0);
        ArrayList sendingForms = new ArrayList(SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending0.getGroupForms()));
        Assert.assertEquals((long)4L, (long)sendingForms.size());
        ArrayList formsIdsToRemove = new ArrayList();
        formsIdsToRemove.add(sendingForms.get(0));
        formsIdsToRemove.add(sendingForms.get(1));
        this.storageService.removeFormsFromSession(session.getWikittyId(), formsIdsToRemove);
        session = (Session)this.wikittyProxy.restore(Session.class, session.getWikittyId());
        sendings = this.wikittyProxy.restore(Sending.class, new ArrayList(session.getSending()));
        Assert.assertEquals((long)3L, (long)sendings.size());
        Assert.assertEquals((long)3L, (long)session.getSending().size());
        Set sendingForms0 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(0)).getGroupForms());
        Set sendingForms1 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(1)).getGroupForms());
        Set sendingForms2 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(2)).getGroupForms());
        Assert.assertEquals((long)2L, (long)sendingForms0.size());
        Assert.assertEquals((long)2L, (long)sendingForms1.size());
        Assert.assertEquals((long)2L, (long)sendingForms2.size());
        Set deletedForm0 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(0)).getDeletedGroupForms());
        Set deletedForm1 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(1)).getDeletedGroupForms());
        Set deletedForm2 = SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)((Sending)sendings.get(2)).getDeletedGroupForms());
        Assert.assertEquals((long)2L, (long)deletedForm0.size());
        Assert.assertEquals((long)2L, (long)deletedForm1.size());
        Assert.assertEquals((long)2L, (long)deletedForm2.size());
        for (Sending sending : sendings) {
            sending.setStatus(VradiConstants.SendingStatus.SENT.getValue());
        }
        this.wikittyProxy.store(sendings);
        session.setStatus(VradiConstants.SessionStatus.SENT.getValue());
        this.wikittyProxy.store((BusinessEntity)session);
        session = this.storageService.createNewSession();
        session = this.storageService.bindForms((Session)session);
        Set sendingIds = session.getSending();
        sendings = this.wikittyProxy.restore(Sending.class, new ArrayList(sendingIds));
        for (Sending sending : sendings) {
            for (String deletedId : formsIdsToRemove) {
                Assert.assertFalse((boolean)SendingHelper.extractForms((WikittyProxy)this.wikittyProxy, (Collection)sending.getGroupForms()).contains(deletedId));
            }
        }
    }

    @Test(expected=VradiException.class)
    public void testInvalidRootThesaurus() throws VradiException {
        this.dataService.createRootThesaurus("\u00e9t\u00e9");
    }

    @Test(expected=VradiException.class)
    public void testInvalidRootThesaurus2() throws VradiException {
        this.dataService.createRootThesaurus("test test");
    }

    @Test(expected=VradiException.class)
    public void testInvalidRootThesaurus3() throws VradiException {
        this.dataService.createRootThesaurus("test+test");
    }

    @Test(expected=VradiException.class)
    public void testInvalidRootThesaurus4() throws VradiException {
        this.dataService.createRootThesaurus(null);
    }

    @Test
    public void testNomUniqueRootThesaurus() throws VradiException {
        block2: {
            RootThesaurus rootThesaurus = this.dataService.createRootThesaurus("uniquename");
            Assert.assertNotNull((Object)rootThesaurus);
            try {
                this.dataService.createRootThesaurus("uniquename");
                Assert.fail((String)"Root thesaurus created twice");
            }
            catch (VradiException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't create root thesaurus", (Throwable)ex);
            }
        }
    }
}

