/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.variables;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.webharvest.exception.VariableException;
import org.webharvest.runtime.variables.Variable;

public class NodeVariable
extends Variable {
    private Object data;

    public NodeVariable(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return "";
        }
        if (this.data instanceof byte[]) {
            return new String((byte[])this.data);
        }
        return this.data.toString();
    }

    @Override
    public String toString(String charset) {
        if (this.data == null) {
            return "";
        }
        if (this.data instanceof byte[]) {
            try {
                return new String((byte[])this.data, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new VariableException(e);
            }
        }
        return this.data.toString();
    }

    @Override
    public byte[] toBinary() {
        if (this.data == null) {
            return new byte[0];
        }
        if (this.data instanceof byte[]) {
            return (byte[])this.data;
        }
        return this.data.toString().getBytes();
    }

    @Override
    public byte[] toBinary(String charset) {
        if (charset == null || this.data == null || this.data instanceof byte[]) {
            return this.toBinary();
        }
        try {
            return this.data.toString().getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new VariableException(e);
        }
    }

    @Override
    public List toList() {
        ArrayList<NodeVariable> list = new ArrayList<NodeVariable>();
        if (!this.isEmpty()) {
            list.add(this);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null || "".equals(this.toString());
    }

    @Override
    public Object getWrappedObject() {
        return this.data;
    }
}

