/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.ZipEntryPlugin;
import org.webharvest.runtime.processors.plugins.ZipPluginException;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;

public class ZipPlugin
extends WebHarvestPlugin {
    private ZipOutputStream zipOutStream = null;

    @Override
    public String getName() {
        return "zip";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.zipOutStream = new ZipOutputStream(byteArrayOutputStream);
        this.executeBody(scraper, context);
        try {
            this.zipOutStream.close();
        }
        catch (IOException e) {
            throw new ZipPluginException(e);
        }
        return new NodeVariable(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String[] getValidAttributes() {
        return new String[0];
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[0];
    }

    @Override
    public Class[] getDependantProcessors() {
        return new Class[]{ZipEntryPlugin.class};
    }

    public ZipOutputStream getZipOutStream() {
        return this.zipOutStream;
    }
}

