/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.MetaClass;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractHttpServlet
extends HttpServlet
implements ResourceConnector {
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String INC_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INC_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INC_SERVLET_PATH = "javax.servlet.include.servlet_path";
    protected ServletContext servletContext = null;
    protected Matcher resourceNameMatcher = null;
    protected String resourceNameReplacement = null;
    protected boolean resourceNameReplaceAll = true;
    protected boolean verbose = false;
    protected boolean reflection = false;
    private boolean logGROOVY861 = false;

    public URLConnection getResourceConnection(String name) throws ResourceException {
        Matcher matcher = this.resourceNameMatcher;
        if (matcher != null) {
            matcher.reset(name);
            String replaced = this.resourceNameReplaceAll ? this.resourceNameMatcher.replaceAll(this.resourceNameReplacement) : this.resourceNameMatcher.replaceFirst(this.resourceNameReplacement);
            if (!name.equals(replaced)) {
                if (this.verbose) {
                    this.log("Replaced resource name \"" + name + "\" with \"" + replaced + "\".");
                }
                name = replaced;
            }
        }
        try {
            URL url = this.servletContext.getResource("/" + name);
            if (url == null) {
                url = this.servletContext.getResource("/WEB-INF/groovy/" + name);
            }
            if (url == null) {
                throw new ResourceException("Resource \"" + name + "\" not found!");
            }
            return url.openConnection();
        }
        catch (IOException e) {
            throw new ResourceException("Problems getting resource named \"" + name + "\"!", e);
        }
    }

    protected String getScriptUri(HttpServletRequest request) {
        if (this.logGROOVY861) {
            this.log("Logging request class and its class loader:");
            this.log(" c = request.getClass() :\"" + request.getClass() + "\"");
            this.log(" l = c.getClassLoader() :\"" + request.getClass().getClassLoader() + "\"");
            this.log(" l.getClass()           :\"" + request.getClass().getClassLoader().getClass() + "\"");
            this.logGROOVY861 = this.verbose;
        }
        String uri = null;
        String info = null;
        uri = (String)request.getAttribute(INC_SERVLET_PATH);
        if (uri != null) {
            info = (String)request.getAttribute(INC_PATH_INFO);
            if (info != null) {
                uri = uri + info;
            }
            return uri;
        }
        uri = request.getServletPath();
        info = request.getPathInfo();
        if (info != null) {
            uri = uri + info;
        }
        return uri;
    }

    protected File getScriptUriAsFile(HttpServletRequest request) {
        String uri = this.getScriptUri(request);
        String real = this.servletContext.getRealPath(uri);
        File file = new File(real).getAbsoluteFile();
        return file;
    }

    public void init(ServletConfig config) throws ServletException {
        String regex;
        super.init(config);
        this.servletContext = config.getServletContext();
        String value = config.getInitParameter("verbose");
        if (value != null) {
            this.verbose = Boolean.valueOf(value);
        }
        if (this.verbose) {
            this.log("Parsing init parameters...");
        }
        if ((regex = config.getInitParameter("resource.name.regex")) != null) {
            String replacement = config.getInitParameter("resource.name.replacement");
            if (replacement == null) {
                NullPointerException npex = new NullPointerException("resource.name.replacement");
                String message = "Init-param 'resource.name.replacement' not specified!";
                this.log(message, npex);
                throw new ServletException(message, (Throwable)npex);
            }
            int flags = 0;
            this.resourceNameMatcher = Pattern.compile(regex, flags).matcher("");
            this.resourceNameReplacement = replacement;
            String all = config.getInitParameter("resource.name.replace.all");
            if (all != null) {
                this.resourceNameReplaceAll = Boolean.valueOf(all);
            }
        }
        if ((value = config.getInitParameter("reflection")) != null) {
            this.reflection = Boolean.valueOf(value);
            MetaClass.setUseReflection(this.reflection);
        }
        if ((value = config.getInitParameter("logGROOVY861")) != null) {
            this.logGROOVY861 = Boolean.valueOf(value);
        }
        if (this.verbose) {
            this.log("(Abstract) init done. Listing some parameter name/value pairs:");
            this.log("verbose = " + this.verbose);
            this.log("reflection = " + this.reflection);
            this.log("logGROOVY861 = " + this.logGROOVY861);
            if (this.resourceNameMatcher != null) {
                this.log("resource.name.regex = " + this.resourceNameMatcher.pattern().pattern());
            } else {
                this.log("resource.name.regex = null");
            }
            this.log("resource.name.replacement = " + this.resourceNameReplacement);
        }
    }
}

