/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriter;

final class DocFieldProcessor
extends DocConsumer {
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos = new FieldInfos();
    final DocFieldConsumer consumer;
    final StoredFieldsWriter fieldsWriter;

    public DocFieldProcessor(DocumentsWriter docWriter, DocFieldConsumer consumer) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        consumer.setFieldInfos(this.fieldInfos);
        this.fieldsWriter = new StoredFieldsWriter(docWriter, this.fieldInfos);
    }

    public void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.fieldsWriter.closeDocStore(state);
    }

    public void flush(Collection threads, SegmentWriteState state) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection> childThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection>();
        Iterator it = threads.iterator();
        while (it.hasNext()) {
            DocFieldProcessorPerThread perThread = (DocFieldProcessorPerThread)it.next();
            childThreadsAndFields.put(perThread.consumer, perThread.fields());
            perThread.trimFields(state);
        }
        this.fieldsWriter.flush(state);
        this.consumer.flush(childThreadsAndFields, state);
        String fileName = state.segmentFileName("fnm");
        this.fieldInfos.write(state.directory, fileName);
        state.flushedFiles.add(fileName);
    }

    public void abort() {
        this.fieldsWriter.abort();
        this.consumer.abort();
    }

    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    public DocConsumerPerThread addThread(DocumentsWriterThreadState threadState) throws IOException {
        return new DocFieldProcessorPerThread(threadState, this);
    }
}

