/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.debug.ProtocolTester;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FragTest {
    public static final long NUM_MSGS = 10L;
    public static final int MSG_SIZE = 100000;
    public static final int FRAG_SIZE = 24000;

    private static Message createBigMessage(int size) {
        byte[] buf = new byte[size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 120;
        }
        return new Message(null, null, buf);
    }

    public void testRegularMessages() throws Exception {
        FragReceiver frag_receiver = new FragReceiver(this);
        ProtocolTester t = new ProtocolTester("FRAG2(frag_size=24000)", frag_receiver);
        IpAddress local_addr = new IpAddress(5555);
        System.out.println("\nProtocol for protocol tester: " + t.getProtocolSpec() + '\n');
        int i = 0;
        while ((long)i < 10L) {
            Message big_msg = FragTest.createBigMessage(100000);
            big_msg.setSrc(local_addr);
            System.out.println("sending msg #" + i + " [" + big_msg.getLength() + " bytes]");
            frag_receiver.down(new Event(1, big_msg));
            Util.sleep(10L);
            ++i;
        }
        t.stop();
    }

    public void testMessagesWithOffsets() throws Exception {
        FragReceiver frag_receiver = new FragReceiver(this);
        ProtocolTester t = new ProtocolTester("FRAG2(frag_size=24000)", frag_receiver);
        IpAddress local_addr = new IpAddress(5555);
        System.out.println("\nProtocol for protocol tester: " + t.getProtocolSpec() + '\n');
        byte[] big_buffer = new byte[1000000];
        int offset = 0;
        int i = 0;
        while ((long)i < 10L) {
            Message big_msg = new Message(null, null, big_buffer, offset, 100000);
            big_msg.setSrc(local_addr);
            System.out.println("sending msg #" + i + " [" + big_msg.getLength() + " bytes]");
            frag_receiver.down(new Event(1, big_msg));
            Util.sleep(10L);
            offset += 100000;
            ++i;
        }
        t.stop();
    }

    private static class FragReceiver
    extends Protocol {
        long num_msgs = 0L;
        FragTest t = null;

        FragReceiver(FragTest t) {
            this.t = t;
        }

        @Override
        public Object up(Event evt) {
            Message msg = null;
            if (evt == null || evt.getType() != 1) {
                return null;
            }
            msg = (Message)evt.getArg();
            Address sender = msg.getSrc();
            if (sender == null) {
                this.log.error("FragTest.FragReceiver.up(): sender is null; discarding msg");
                return null;
            }
            System.out.println("Received msg from " + sender + " [" + msg.getLength() + " bytes]");
            return null;
        }
    }
}

