/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Protocol to discover subgroups existing due to a network partition")
@DeprecatedProperty(names={"use_separate_thread"})
public class MERGE2
extends Protocol {
    @Property(description="Minimum time in msbetween runs to discover other clusters")
    protected long min_interval = 5000L;
    @Property(description="Maximum time in ms between runs to discover other clusters")
    protected long max_interval = 20000L;
    @Property(description="Number of inconsistent  views with only 1 coord after a MERGE event is sent up")
    protected int inconsistent_view_threshold = 1;
    @Property(description="When receiving a multicast message, checks if the sender is member of the cluster. If not, initiates a merge")
    protected boolean merge_fast = true;
    @Property(description="The delay (in milliseconds) after which a merge fast execution is started")
    protected long merge_fast_delay = 1000L;
    private Address local_addr = null;
    private View view;
    private final Set<Address> members = new HashSet<Address>();
    private final Set<Address> merge_candidates = new HashSet<Address>();
    private final FindSubgroupsTask task = new FindSubgroupsTask();
    private volatile boolean is_coord = false;
    private TimeScheduler timer;
    @ManagedAttribute(description="Number of inconsistent 1-coord views until a MERGE event is sent up the stack")
    private int num_inconsistent_views = 0;

    @ManagedAttribute(writable=false, description="whether or not a merge task is currently running (should be the case in a coordinator")
    public boolean isMergeTaskRunning() {
        return this.task.isRunning();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            throw new Exception("min_interval and max_interval have to be > 0");
        }
        if (this.max_interval <= this.min_interval) {
            throw new Exception("max_interval has to be greater than min_interval");
        }
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(12));
        return retval;
    }

    @ManagedOperation
    public void sendMergeSolicitation() {
        this.task.findAndNotify();
    }

    @ManagedOperation
    public void startMergeTask() {
        this.task.start();
    }

    @ManagedOperation
    public void stopMergeTask() {
        this.task.stop();
    }

    @Override
    public void stop() {
        this.is_coord = false;
        this.merge_candidates.clear();
        this.task.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                Vector<Address> mbrs = this.view.getMembers();
                if (mbrs == null || mbrs.isEmpty() || this.local_addr == null) {
                    this.task.stop();
                    return ret;
                }
                this.members.clear();
                this.members.addAll(mbrs);
                this.merge_candidates.removeAll(this.members);
                Address coord = mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.task.start();
                } else {
                    if (this.is_coord) {
                        this.is_coord = false;
                    }
                    this.task.stop();
                }
                return ret;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Address sender;
                boolean multicast;
                if (!this.merge_fast) break;
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                boolean bl = multicast = dest == null || dest.isMulticastAddress();
                if (!multicast || this.members.contains(sender = msg.getSrc()) || !this.merge_candidates.add(sender)) break;
                this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (!MERGE2.this.members.contains(sender)) {
                            MERGE2.this.task.findAndNotify();
                        }
                    }
                }, this.merge_fast_delay, TimeUnit.MILLISECONDS);
            }
        }
        return this.up_prot.up(evt);
    }

    private class FindSubgroupsTask {
        private Future<?> future;
        private Lock lock = new ReentrantLock();

        private FindSubgroupsTask() {
        }

        public synchronized void start() {
            if (this.future == null || this.future.isDone() || this.future.isCancelled()) {
                this.future = MERGE2.this.timer.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        FindSubgroupsTask.this.findAndNotify();
                    }
                }, Math.max(5000L, this.computeInterval()), this.computeInterval(), TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        public synchronized boolean isRunning() {
            return this.future != null && !this.future.isDone() && !this.future.isCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findAndNotify() {
            if (this.lock.tryLock()) {
                try {
                    this._findAndNotify();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private void _findAndNotify() {
            Map<Address, View> views;
            List<View> different_views;
            List<PingData> discovery_rsps = this.findAllMembers();
            if (MERGE2.this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Discovery results:\n");
                for (PingData data : discovery_rsps) {
                    sb.append("[" + data.getAddress() + "]: " + data.getView()).append("\n");
                }
                MERGE2.this.log.trace(sb);
            }
            if ((different_views = this.detectDifferentViews(views = this.getViews(discovery_rsps))).size() <= 1) {
                MERGE2.this.num_inconsistent_views = 0;
                return;
            }
            Collection<Address> merge_participants = Util.determineMergeParticipants(views);
            if (merge_participants.size() == 1) {
                if (MERGE2.this.num_inconsistent_views < MERGE2.this.inconsistent_view_threshold) {
                    if (MERGE2.this.log.isDebugEnabled()) {
                        MERGE2.this.log.debug("dropping MERGE for inconsistent views " + Util.printViews(different_views) + " as inconsistent view threshold (" + MERGE2.this.inconsistent_view_threshold + ") has not yet been reached (" + MERGE2.this.num_inconsistent_views + ")");
                    }
                    MERGE2.this.num_inconsistent_views++;
                    return;
                }
                MERGE2.this.num_inconsistent_views = 0;
            } else {
                MERGE2.this.num_inconsistent_views = 0;
            }
            if (MERGE2.this.log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(MERGE2.this.local_addr + " found different views : " + Util.printViews(different_views) + "; sending up MERGE event with merge participants " + merge_participants + ".\n");
                sb.append("Discovery results:\n");
                for (PingData data : discovery_rsps) {
                    sb.append("[" + data.getAddress() + "]: " + data.getView()).append("\n");
                }
                MERGE2.this.log.debug(sb.toString());
            }
            Event evt = new Event(14, views);
            try {
                MERGE2.this.up_prot.up(evt);
            }
            catch (Throwable t) {
                MERGE2.this.log.error("failed sending up MERGE event", t);
            }
        }

        long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }

        private List<PingData> findAllMembers() {
            PingData tmp;
            List retval = (List)MERGE2.this.down_prot.down(new Event(13));
            if (retval == null) {
                return Collections.emptyList();
            }
            if (MERGE2.this.is_coord && MERGE2.this.local_addr != null && !retval.contains(tmp = new PingData(MERGE2.this.local_addr, MERGE2.this.view, true))) {
                retval.add(tmp);
            }
            return retval;
        }

        public Map<Address, View> getViews(List<PingData> initial_mbrs) {
            HashMap<Address, View> retval = new HashMap<Address, View>();
            for (PingData response : initial_mbrs) {
                if (!response.isServer()) continue;
                Address sender = response.getAddress();
                View view = response.getView();
                if (sender == null || view == null) continue;
                retval.put(sender, view);
            }
            return retval;
        }

        public List<View> detectDifferentViews(Map<Address, View> map) {
            ArrayList<View> ret = new ArrayList<View>();
            for (View view : map.values()) {
                ViewId vid;
                if (view == null || Util.containsViewId(ret, vid = view.getVid())) continue;
                ret.add(view);
            }
            return ret;
        }
    }
}

