/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.FRAG;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherTest
extends ChannelTestBase {
    RpcDispatcher disp1;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    JChannel c1;
    JChannel c2;
    JChannel c3;
    static final int[] SIZES = new int[]{10000, 20000, 40000, 80000, 100000, 200000, 400000, 800000, 1000000, 2000000, 5000000};
    static final int[] HUGESIZES = new int[]{10000000, 20000000};

    @BeforeMethod
    protected void setUp() throws Exception {
        this.c1 = this.createChannel(true, 3);
        this.c1.setName("A");
        String GROUP = "RpcDispatcherTest";
        this.disp1 = new RpcDispatcher((Channel)this.c1, null, null, new ServerObject(1));
        this.c1.connect("RpcDispatcherTest");
        this.c2 = this.createChannel(this.c1);
        this.c2.setName("B");
        this.disp2 = new RpcDispatcher((Channel)this.c2, null, null, new ServerObject(2));
        this.c2.connect("RpcDispatcherTest");
        this.c3 = this.createChannel(this.c1);
        this.c3.setName("C");
        this.disp3 = new RpcDispatcher((Channel)this.c3, null, null, new ServerObject(3));
        this.c3.connect("RpcDispatcherTest");
        System.out.println("c1.view=" + this.c1.getView() + "\nc2.view=" + this.c2.getView() + "\nc3.view=" + this.c3.getView());
        View view = this.c3.getView();
        assert (view.size() == 3) : "view=" + view;
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.disp3.stop();
        this.disp2.stop();
        this.disp1.stop();
        Util.close(this.c3, this.c2, this.c1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyConstructor() throws Exception {
        RpcDispatcher d1 = new RpcDispatcher();
        RpcDispatcher d2 = new RpcDispatcher();
        JChannel channel1 = null;
        JChannel channel2 = null;
        String GROUP = RpcDispatcherTest.getUniqueClusterName("RpcDispatcherTest");
        try {
            channel1 = this.createChannel(true, 2);
            channel2 = this.createChannel(channel1);
            d1.setChannel(channel1);
            d2.setChannel(channel2);
            d1.setServerObject(new ServerObject(1));
            d2.setServerObject(new ServerObject(2));
            d1.start();
            d2.start();
            channel1.connect(GROUP);
            channel2.connect(GROUP);
            Util.sleep(500L);
            View view = channel2.getView();
            System.out.println("view channel 2= " + view);
            view = channel1.getView();
            System.out.println("view channel 1= " + view);
            assert (view.size() == 2);
            RspList rsps = d1.callRemoteMethods(null, "foo", null, null, new RequestOptions(2, 5000L));
            System.out.println("rsps:\n" + rsps);
            assert (rsps.size() == 2);
            for (Rsp rsp : rsps.values()) {
                assert (rsp.wasReceived());
                assert (!rsp.wasSuspected());
                assert (rsp.getValue() != null);
            }
            Object server_object = new Object(){

                public long foobar() {
                    return System.currentTimeMillis();
                }
            };
            d1.setServerObject(server_object);
            d2.setServerObject(server_object);
            rsps = d2.callRemoteMethods(null, "foobar", null, null, new RequestOptions(2, 5000L));
            System.out.println("rsps:\n" + rsps);
            assert (rsps.size() == 2);
            for (Rsp rsp : rsps.values()) {
                assert (rsp.wasReceived());
                assert (!rsp.wasSuspected());
                assert (rsp.getValue() != null);
            }
        }
        catch (Throwable throwable) {
            d2.stop();
            d1.stop();
            Util.close(channel2, channel1);
            throw throwable;
        }
        d2.stop();
        d1.stop();
        Util.close(channel2, channel1);
    }

    public void testResponseFilter() {
        long timeout = 10000L;
        RequestOptions options = new RequestOptions(2, 10000L, false, new RspFilter(){
            int num = 0;

            @Override
            public boolean isAcceptable(Object response, Address sender) {
                boolean retval;
                boolean bl = retval = (Integer)response > 1;
                if (retval) {
                    ++this.num;
                }
                return retval;
            }

            @Override
            public boolean needMoreResponses() {
                return this.num < 2;
            }
        });
        RspList rsps = this.disp1.callRemoteMethods(null, "foo", null, null, options);
        System.out.println("responses are:\n" + rsps);
        RpcDispatcherTest.assertEquals("there should be three response values", 3, rsps.size());
        RpcDispatcherTest.assertEquals("number of responses received should be 2", 2, rsps.numReceived());
    }

    public void testFuture() throws Exception {
        MethodCall sleep = new MethodCall("sleep", new Object[]{1000L}, new Class[]{Long.TYPE});
        NotifyingFuture<RspList> future = this.disp1.callRemoteMethodsWithFuture(null, sleep, new RequestOptions(2, 5000L, false, null));
        assert (!future.isDone());
        assert (!future.isCancelled());
        try {
            future.get(300L, TimeUnit.MILLISECONDS);
            assert (false) : "we should not get here, get(300) should have thrown a TimeoutException";
        }
        catch (TimeoutException e) {
            System.out.println("got TimeoutException - as expected");
        }
        assert (!future.isDone());
        RspList result = (RspList)future.get(6000L, TimeUnit.MILLISECONDS);
        System.out.println("result:\n" + result);
        assert (result != null);
        assert (result.size() == 3);
        assert (future.isDone());
    }

    public void testNotifyingFuture() throws Exception {
        MethodCall sleep = new MethodCall("sleep", new Object[]{1000L}, new Class[]{Long.TYPE});
        MyFutureListener listener = new MyFutureListener();
        NotifyingFuture<RspList> future = this.disp1.callRemoteMethodsWithFuture(null, sleep, new RequestOptions(2, 5000L, false, null));
        future.setListener(listener);
        assert (!future.isDone());
        assert (!future.isCancelled());
        assert (!listener.isDone());
        Util.sleep(2000L);
        assert (listener.isDone());
        RspList result = (RspList)future.get(1L, TimeUnit.MILLISECONDS);
        System.out.println("result:\n" + result);
        assert (result != null);
        assert (result.size() == 3);
        assert (future.isDone());
    }

    public void testNotifyingFutureWithDelayedListener() throws Exception {
        MethodCall sleep = new MethodCall("sleep", new Object[]{1000L}, new Class[]{Long.TYPE});
        MyFutureListener listener = new MyFutureListener();
        NotifyingFuture<RspList> future = this.disp1.callRemoteMethodsWithFuture(null, sleep, new RequestOptions(2, 5000L, false, null));
        assert (!future.isDone());
        assert (!future.isCancelled());
        Util.sleep(2000L);
        future.setListener(listener);
        assert (listener.isDone());
        RspList result = (RspList)future.get(1L, TimeUnit.MILLISECONDS);
        System.out.println("result:\n" + result);
        assert (result != null);
        assert (result.size() == 3);
        assert (future.isDone());
    }

    public void testMultipleFutures() throws Exception {
        Future<RspList> future;
        MethodCall sleep = new MethodCall("sleep", new Object[]{100L}, new Class[]{Long.TYPE});
        ArrayList<NotifyingFuture<RspList>> futures = new ArrayList<NotifyingFuture<RspList>>();
        long target = System.currentTimeMillis() + 30000L;
        RequestOptions options = new RequestOptions(2, 30000L, false, null);
        for (int i = 0; i < 10; ++i) {
            future = this.disp1.callRemoteMethodsWithFuture(null, sleep, options);
            futures.add((NotifyingFuture<RspList>)future);
        }
        ArrayList<Future<RspList>> rsps = new ArrayList<Future<RspList>>();
        while (!futures.isEmpty() && System.currentTimeMillis() < target) {
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                future = (Future)it.next();
                if (!future.isDone()) continue;
                it.remove();
                rsps.add(future);
            }
            System.out.println("pending responses: " + futures.size());
            Util.sleep(200L);
        }
        System.out.println("\n" + rsps.size() + " responses:\n");
        for (Future future2 : rsps) {
            System.out.println(future2);
        }
    }

    public void testMultipleNotifyingFutures() throws Exception {
        int i;
        MethodCall sleep = new MethodCall("sleep", new Object[]{100L}, new Class[]{Long.TYPE});
        ArrayList listeners = new ArrayList();
        RequestOptions options = new RequestOptions(2, 30000L, false, null);
        for (i = 0; i < 10; ++i) {
            MyFutureListener myFutureListener = new MyFutureListener();
            listeners.add(myFutureListener);
            this.disp1.callRemoteMethodsWithFuture(null, sleep, options).setListener(myFutureListener);
        }
        Util.sleep(1000L);
        for (i = 0; i < 10; ++i) {
            boolean bl;
            boolean bl2 = true;
            for (MyFutureListener myFutureListener : listeners) {
                boolean done = myFutureListener.isDone();
                System.out.print(done ? "+ " : "- ");
                if (myFutureListener.isDone()) continue;
                bl = false;
            }
            if (bl) break;
            Util.sleep(500L);
            System.out.println("");
        }
        for (MyFutureListener myFutureListener : listeners) {
            assert (myFutureListener.isDone());
        }
    }

    public void testFutureCancel() throws Exception {
        MethodCall sleep = new MethodCall("sleep", new Object[]{1000L}, new Class[]{Long.TYPE});
        NotifyingFuture<RspList> future = this.disp1.callRemoteMethodsWithFuture(null, sleep, new RequestOptions(2, 5000L));
        assert (!future.isDone());
        assert (!future.isCancelled());
        future.cancel(true);
        assert (future.isDone());
        assert (future.isCancelled());
        future = this.disp1.callRemoteMethodsWithFuture(null, sleep, new RequestOptions(2, 0L));
        assert (!future.isDone());
        assert (!future.isCancelled());
        future.cancel(true);
        assert (future.isDone());
        assert (future.isCancelled());
    }

    public void testLargeReturnValue() {
        RpcDispatcherTest.setProps(this.c1, this.c2, this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValue(SIZES[i]);
        }
    }

    public void testMethodInvocationToNonExistingMembers() {
        int timeout = 5000;
        View view = this.c3.getView();
        Vector<Address> members = view.getMembers();
        System.out.println("list is " + members);
        System.out.println("closing c3");
        this.c3.close();
        Util.sleep(1000L);
        System.out.println("calling method foo() in " + members + " (view=" + this.c2.getView() + ")");
        RspList rsps = this.disp1.callRemoteMethods(members, "foo", null, null, new RequestOptions(2, 5000L));
        System.out.println("responses:\n" + rsps);
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Rsp rsp = entry.getValue();
            RpcDispatcherTest.assertTrue("response from " + entry.getKey() + " was not received", rsp.wasReceived());
            RpcDispatcherTest.assertFalse(rsp.wasSuspected());
        }
    }

    public void testLargeReturnValueUnicastCall() throws Throwable {
        RpcDispatcherTest.setProps(this.c1, this.c2, this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValueUnicastCall(this.c1.getAddress(), SIZES[i]);
        }
    }

    private static void setProps(JChannel ... channels) {
        for (JChannel ch : channels) {
            Protocol prot = ch.getProtocolStack().findProtocol("FRAG2");
            if (prot != null) {
                ((FRAG2)prot).setFragSize(12000);
            }
            if ((prot = ch.getProtocolStack().findProtocol("FRAG")) != null) {
                ((FRAG)prot).setFragSize(12000);
            }
            if ((prot = ch.getProtocolStack().getTransport()) == null) continue;
            ((TP)prot).setMaxBundleSize(14000);
        }
    }

    void _testLargeValue(int size) {
        long timeout = 20000L;
        System.out.println("\ntesting with " + size + " bytes");
        RspList rsps = this.disp1.callRemoteMethods(null, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, new RequestOptions(2, 20000L));
        System.out.println("rsps:");
        assert (rsps.size() == 3) : "there should be three responses to the RPC call but only " + rsps.size() + " were received: " + rsps;
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Object obj = entry.getValue().getValue();
            assert (!(obj instanceof Throwable)) : "exception was raised in processing reasonably sized argument";
            byte[] val = (byte[])obj;
            assert (val != null);
            System.out.println(val.length + " bytes from " + entry.getValue().getSender());
            assert (val.length == size) : "return value does not match required size";
        }
    }

    void _testHugeValue(int size) {
        long timeout = 20000L;
        System.out.println("\ntesting with " + size + " bytes");
        RspList rsps = this.disp1.callRemoteMethods(null, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, new RequestOptions(2, 20000L));
        System.out.println("rsps:");
        assert (rsps != null);
        assert (rsps.size() == 3) : "there should be three responses to the RPC call but only " + rsps.size() + " were received: " + rsps;
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Object obj = entry.getValue().getValue();
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                System.out.println(t.toString() + " exception was raised processing argument from " + entry.getValue().getSender() + " -this is expected");
                continue;
            }
            if (obj == null) {
                System.out.println("request timed out processing argument from " + entry.getValue().getSender() + " - this is expected");
                continue;
            }
            byte[] val = (byte[])obj;
            System.out.println(val.length + " bytes from " + entry.getValue().getSender());
            assert (val.length == size) : "return value does not match required size";
        }
    }

    void _testLargeValueUnicastCall(Address dst, int size) throws Throwable {
        long timeout = 20000L;
        System.out.println("\ntesting unicast call with " + size + " bytes");
        RpcDispatcherTest.assertNotNull(dst);
        Object retval = this.disp1.callRemoteMethod(dst, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, new RequestOptions(2, 20000L));
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        byte[] val = (byte[])retval;
        RpcDispatcherTest.assertNotNull("return value should be non-null", val);
        System.out.println("rsp: " + val.length + " bytes");
        RpcDispatcherTest.assertEquals("return value does not match requested size", size, val.length);
    }

    private static class MyFutureListener<T>
    implements FutureListener<T> {
        private boolean done;

        private MyFutureListener() {
        }

        @Override
        public void futureDone(Future<T> future) {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    private static class ServerObject {
        int i;

        public ServerObject(int i) {
            this.i = i;
        }

        public int foo() {
            return this.i;
        }

        public static long sleep(long timeout) {
            long start = System.currentTimeMillis();
            Util.sleep(timeout);
            return System.currentTimeMillis() - start;
        }

        public static byte[] largeReturnValue(int size) {
            return new byte[size];
        }
    }
}

