/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ApplyImports
extends Instruction {
    WithParam[] actualParams = null;
    WithParam[] tunnelParams = null;
    private boolean backwardsCompatible;

    public ApplyImports(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public void setActualParameters(WithParam[] withParamArray, WithParam[] withParamArray2) {
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
    }

    public int getInstructionNameCode() {
        return 129;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        WithParam.simplify(this.actualParams, staticContext);
        WithParam.simplify(this.tunnelParams, staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, staticContext, itemType);
        WithParam.typeCheck(this.tunnelParams, staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.optimize(optimizer, this.actualParams, staticContext, itemType);
        WithParam.optimize(optimizer, this.tunnelParams, staticContext, itemType);
        return this;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        WithParam.promoteParams(this.actualParams, promotionOffer);
        WithParam.promoteParams(this.tunnelParams, promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList arrayList = new ArrayList(10);
        WithParam.getXPathExpressions(this.actualParams, arrayList);
        WithParam.getXPathExpressions(this.tunnelParams, arrayList);
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = ApplyImports.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = ApplyImports.assembleTunnelParams(xPathContext, this.tunnelParams);
        Template template = xPathContext.getCurrentTemplate();
        if (template == null) {
            DynamicError dynamicError = new DynamicError("There is no current template rule");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0560");
            dynamicError.setLocator(this);
            throw dynamicError;
        }
        int n = template.getMinImportPrecedence();
        int n2 = template.getPrecedence() - 1;
        Mode mode = xPathContext.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getMode(-1);
        }
        if (xPathContext.getCurrentIterator() == null) {
            DynamicError dynamicError = new DynamicError("Cannot call xsl:apply-imports when there is no context item");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0565");
            dynamicError.setLocator(this);
            throw dynamicError;
        }
        Item item = xPathContext.getCurrentIterator().current();
        if (!(item instanceof NodeInfo)) {
            DynamicError dynamicError = new DynamicError("Cannot call xsl:apply-imports when context item is not a node");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0565");
            dynamicError.setLocator(this);
            throw dynamicError;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        Template template2 = controller.getRuleManager().getTemplateRule(nodeInfo, mode, n, n2, xPathContext);
        if (template2 == null) {
            ApplyTemplates.defaultAction(nodeInfo, parameterSet, parameterSet2, xPathContext, this.backwardsCompatible, this.getLocationId());
        } else {
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.setLocalParameters(parameterSet);
            xPathContextMajor.setTunnelParameters(parameterSet2);
            xPathContextMajor.openStackFrame(template2.getStackFrameMap());
            template2.process(xPathContextMajor);
        }
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "apply-imports");
    }
}

